/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.apache.servicemix.kernel.main.spi.MainService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
implements MainService,
BundleActivator {
    public static final String SYSTEM_PROPERTIES_FILE_NAME = "system.properties";
    public static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    public static final String STARTUP_PROPERTIES_FILE_NAME = "startup.properties";
    public static final String PROPERTY_AUTO_INSTALL = "felix.auto.install";
    public static final String PROPERTY_AUTO_START = "felix.auto.start";
    public static final String PROP_SERVICEMIX_HOME = "servicemix.home";
    public static final String ENV_SERVICEMIX_HOME = "SERVICEMIX_HOME";
    public static final String PROP_SERVICEMIX_BASE = "servicemix.base";
    public static final String ENV_SERVICEMIX_BASE = "SERVICEMIX_BASE";
    public static final String BUNDLE_LOCATIONS = "bundle.locations";
    public static final String PROPERTY_CONVERT_TO_MAVEN_URL = "servicemix.maven.convert";
    private File servicemixHome;
    private File servicemixBase;
    private static Properties m_configProps = null;
    private static Felix m_felix = null;
    private final String[] args;
    private int exitCode;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public Main(String[] args) {
        this.args = args;
    }

    @Override
    public void start(BundleContext context) {
        Main.processAutoProperties(context);
    }

    @Override
    public void stop(BundleContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final Main main = new Main(args);
        main.servicemixHome = Main.getServiceMixHome();
        main.servicemixBase = Main.getServiceMixBase(main.servicemixHome);
        System.setProperty(PROP_SERVICEMIX_HOME, main.servicemixHome.getPath());
        System.setProperty(PROP_SERVICEMIX_BASE, main.servicemixBase.getPath());
        main.loadSystemProperties();
        m_configProps = main.loadConfigProperties();
        Main.copySystemProperties(m_configProps);
        String profileName = m_configProps.getProperty("felix.cache.profile");
        String profileDirName = m_configProps.getProperty("felix.cache.profiledir");
        if (profileDirName == null && (profileName == null || profileName.length() == 0)) {
            System.err.println("Invalid config.properties configuration.  The profile directory was not specified.");
            System.exit(-1);
        }
        final CountDownLatch shutdown = new CountDownLatch(1);
        BundleActivator activator = new BundleActivator(){
            private ServiceRegistration registration;

            public void start(BundleContext context) {
                this.registration = context.registerService(MainService.class.getName(), (Object)main, null);
            }

            public void stop(BundleContext context) {
                this.registration.unregister();
                shutdown.countDown();
            }
        };
        ArrayList<BundleActivator> activations = new ArrayList<BundleActivator>();
        activations.add(activator);
        activations.add(main);
        try {
            m_felix = new Felix(new StringMap(m_configProps, false), activations);
            m_felix.start();
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
            System.exit(-1);
        }
        try {
            shutdown.await();
            m_felix.stopAndWait();
        }
        catch (Exception ex) {
            System.err.println("Error occured shutting down framework: " + ex);
            ex.printStackTrace();
        }
        finally {
            System.exit(main.getExitCode());
        }
    }

    private static File getServiceMixHome() throws IOException {
        int start;
        String classpath;
        int index;
        URL url;
        File rc = null;
        String path = System.getProperty(PROP_SERVICEMIX_HOME);
        if (path != null) {
            rc = Main.validateDirectoryExists(path, "Invalid servicemix.home system property");
        }
        if (rc == null && (path = System.getenv(ENV_SERVICEMIX_HOME)) != null) {
            rc = Main.validateDirectoryExists(path, "Invalid SERVICEMIX_HOME environment variable");
        }
        if (rc == null && (url = Main.class.getClassLoader().getResource(Main.class.getName().replace(".", "/") + ".class")) != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                rc = new File(new URI(url.toString())).getCanonicalFile().getParentFile().getParentFile();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (rc == null && (index = (classpath = System.getProperty("java.class.path")).toLowerCase().indexOf("servicemix.jar")) >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            rc = new File(jarLocation).getCanonicalFile().getParentFile();
        }
        if (rc == null) {
            throw new IOException("The ServiceMix install directory could not be determined.  Please set the servicemix.home system property or the SERVICEMIX_HOME environment variable.");
        }
        return rc;
    }

    private static File validateDirectoryExists(String path, String errPrefix) {
        File rc;
        try {
            rc = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : " + e.getMessage());
        }
        if (!rc.exists()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : does not exist");
        }
        if (!rc.isDirectory()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : is not a directory");
        }
        return rc;
    }

    private static File getServiceMixBase(File defaultValue) {
        File rc = null;
        String path = System.getProperty(PROP_SERVICEMIX_BASE);
        if (path != null) {
            rc = Main.validateDirectoryExists(path, "Invalid servicemix.base system property");
        }
        if (rc == null && (path = System.getenv(ENV_SERVICEMIX_BASE)) != null) {
            rc = Main.validateDirectoryExists(path, "Invalid SERVICEMIX_BASE environment variable");
        }
        if (rc == null) {
            rc = defaultValue;
        }
        return rc;
    }

    private static void processAutoProperties(BundleContext context) {
        Bundle b;
        String[] parts;
        String location;
        StringTokenizer st;
        int startLevel;
        boolean convertToMavenUrls = Boolean.parseBoolean(m_configProps.getProperty(PROPERTY_CONVERT_TO_MAVEN_URL, "true"));
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        for (String string : m_configProps.keySet()) {
            if (!string.startsWith(PROPERTY_AUTO_INSTALL)) continue;
            startLevel = sl.getInitialBundleStartLevel();
            if (!string.equals(PROPERTY_AUTO_INSTALL)) {
                try {
                    startLevel = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + string);
                }
            }
            if ((st = new StringTokenizer(m_configProps.getProperty(string), "\" ", true)).countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                try {
                    parts = Main.convertToMavenUrlsIfNeeded(location, convertToMavenUrls);
                    b = context.installBundle(parts[0], new URL(parts[1]).openStream());
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install: " + ex);
                }
            } while (location != null);
        }
        for (String string : m_configProps.keySet()) {
            if (!string.startsWith(PROPERTY_AUTO_START)) continue;
            startLevel = sl.getInitialBundleStartLevel();
            if (!string.equals(PROPERTY_AUTO_START)) {
                try {
                    startLevel = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + string);
                }
            }
            if ((st = new StringTokenizer(m_configProps.getProperty(string), "\" ", true)).countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                try {
                    parts = Main.convertToMavenUrlsIfNeeded(location, convertToMavenUrls);
                    b = context.installBundle(parts[0], new URL(parts[1]).openStream());
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install:" + ex);
                }
            } while (location != null);
        }
        for (String string : m_configProps.keySet()) {
            StringTokenizer st2;
            if (!string.startsWith(PROPERTY_AUTO_START) || (st2 = new StringTokenizer(m_configProps.getProperty(string), "\" ", true)).countTokens() <= 0) continue;
            String location2 = null;
            do {
                if ((location2 = Main.nextLocation(st2)) == null) continue;
                try {
                    String[] parts2 = Main.convertToMavenUrlsIfNeeded(location2, convertToMavenUrls);
                    Bundle b2 = context.installBundle(parts2[0], new URL(parts2[1]).openStream());
                    if (b2 == null) continue;
                    b2.start();
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties start: " + ex);
                }
            } while (location2 != null);
        }
    }

    private static String[] convertToMavenUrlsIfNeeded(String location, boolean convertToMavenUrls) {
        String[] parts = location.split("\\|");
        if (convertToMavenUrls) {
            String[] p = parts[1].split("/");
            if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
                Object groupId = null;
                String artifactId = p[p.length - 3];
                String version = p[p.length - 2];
                String artifactIdVersion = artifactId + "-" + version;
                StringBuffer sb = new StringBuffer();
                String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
                String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
                sb.append("mvn:");
                for (int j = 0; j < p.length - 3; ++j) {
                    if (j > 0) {
                        sb.append('.');
                    }
                    sb.append(p[j]);
                }
                sb.append('/').append(artifactId).append('/').append(version);
                if (!"jar".equals(type) || classifier != null) {
                    sb.append('/');
                    if (!"jar".equals(type)) {
                        sb.append(type);
                    }
                    if (classifier != null) {
                        sb.append('/').append(classifier);
                    }
                }
                parts[1] = parts[0];
                parts[0] = sb.toString();
            } else {
                parts[1] = parts[0];
            }
        } else {
            parts[1] = parts[0];
        }
        return parts;
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private void loadSystemProperties() {
        URL propURL = null;
        try {
            File file = new File(new File(this.servicemixBase, "etc"), SYSTEM_PROPERTIES_FILE_NAME);
            propURL = file.toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Main.substVars(props.getProperty(name), name, null, null));
        }
    }

    private Properties loadConfigProperties() {
        StringTokenizer st;
        ArrayList<File> bundleDirs = new ArrayList<File>();
        URL configPropURL = null;
        URL startupPropURL = null;
        try {
            File file = new File(new File(this.servicemixBase, "etc"), CONFIG_PROPERTIES_FILE_NAME);
            configPropURL = file.toURL();
            file = new File(new File(this.servicemixBase, "etc"), STARTUP_PROPERTIES_FILE_NAME);
            startupPropURL = file.toURL();
            if (this.servicemixBase.equals(this.servicemixHome)) {
                bundleDirs.add(new File(this.servicemixHome, "system"));
            } else {
                bundleDirs.add(new File(this.servicemixBase, "system"));
                bundleDirs.add(new File(this.servicemixHome, "system"));
            }
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties configProps = Main.loadPropertiesFile(configPropURL);
        Properties startupProps = Main.loadPropertiesFile(startupPropURL);
        String locations = configProps.getProperty(BUNDLE_LOCATIONS);
        if (locations != null && (st = new StringTokenizer(locations, "\" ", true)).countTokens() > 0) {
            String location = null;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                File f = new File(location);
                if (f.exists() && f.isDirectory()) {
                    bundleDirs.add(f);
                    continue;
                }
                System.err.println("Bundle location " + location + " does not exist or is not a directory.");
            } while (location != null);
        }
        Enumeration<?> e = configProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            configProps.setProperty(name, Main.substVars(configProps.getProperty(name), name, null, configProps));
        }
        Main.processConfigurationProperties(configProps, startupProps, bundleDirs);
        return configProps;
    }

    private static Properties loadPropertiesFile(URL configPropURL) {
        Properties configProps = new Properties();
        InputStream is = null;
        try {
            is = configPropURL.openConnection().getInputStream();
            configProps.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        return configProps;
    }

    private static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.equals("org.osgi.framework.system.packages") && !key.equals("org.osgi.framework.bootdelegation")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    private static void processConfigurationProperties(Properties props, Properties startupProps, ArrayList<File> bundleDirs) {
        if (bundleDirs == null) {
            return;
        }
        if ("all".equals(props.getProperty(PROPERTY_AUTO_START, "").trim())) {
            props.remove(PROPERTY_AUTO_START);
            ArrayList<File> jars = new ArrayList<File>();
            for (File file : bundleDirs) {
                Main.findJars(file, jars);
            }
            StringBuffer sb = new StringBuffer();
            for (File jar : jars) {
                try {
                    sb.append("\"").append(jar.toURL().toString()).append("\" ");
                }
                catch (MalformedURLException e) {
                    System.err.print("Ignoring " + jar.toString() + " (" + e + ")");
                }
            }
            props.setProperty(PROPERTY_AUTO_START, sb.toString());
        } else if (STARTUP_PROPERTIES_FILE_NAME.equals(props.getProperty(PROPERTY_AUTO_START, "").trim())) {
            props.remove(PROPERTY_AUTO_START);
            HashMap<Integer, StringBuffer> levels = new HashMap<Integer, StringBuffer>();
            for (String string : startupProps.keySet()) {
                File file = Main.findFile(bundleDirs, string);
                if (file != null) {
                    Integer level;
                    try {
                        level = new Integer(startupProps.getProperty(string).trim());
                    }
                    catch (NumberFormatException e1) {
                        System.err.print("Ignoring " + file.toString() + " (run level must be an integer)");
                        continue;
                    }
                    StringBuffer sb = (StringBuffer)levels.get(level);
                    if (sb == null) {
                        sb = new StringBuffer(256);
                        levels.put(level, sb);
                    }
                    try {
                        sb.append("\"").append(file.toURL().toString()).append("|").append(string).append("\" ");
                    }
                    catch (MalformedURLException e) {
                        System.err.print("Ignoring " + file.toString() + " (" + e + ")");
                    }
                    continue;
                }
                System.err.println("Bundle listed in startup.properties configuration not found: " + string);
            }
            for (Map.Entry entry : levels.entrySet()) {
                props.setProperty("felix.auto.start." + entry.getKey(), ((StringBuffer)entry.getValue()).toString());
            }
        }
    }

    private static File findFile(ArrayList<File> bundleDirs, String name) {
        for (File bundleDir : bundleDirs) {
            File file = Main.findFile(bundleDir, name);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static File findFile(File dir, String name) {
        File theFile = new File(dir, name);
        if (theFile.exists() && !theFile.isDirectory()) {
            return theFile;
        }
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            return Main.findFile(file, name);
        }
        return null;
    }

    private static void findJars(File dir, ArrayList<File> jars) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Main.findJars(file, jars);
                continue;
            }
            if (!file.toString().endsWith(".jar")) continue;
            jars.add(file);
        }
    }

    private static String substVars(String val, String currentKey, Map<String, String> cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Main.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public File getServicemixHome() {
        return this.servicemixHome;
    }

    public File getServicemixBase() {
        return this.servicemixBase;
    }
}

