/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Source;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jms.endpoints.JmsConsumerMarshaler;

public class DefaultConsumerMarshaler
implements JmsConsumerMarshaler {
    private URI mep;

    public DefaultConsumerMarshaler() {
        this.mep = JbiConstants.IN_ONLY;
    }

    public DefaultConsumerMarshaler(URI mep) {
        this.mep = mep;
    }

    public URI getMep() {
        return this.mep;
    }

    public void setMep(URI mep) {
        this.mep = mep;
    }

    public JmsConsumerMarshaler.JmsContext createContext(Message message) throws Exception {
        return new Context(message);
    }

    public MessageExchange createExchange(JmsConsumerMarshaler.JmsContext jmsContext, ComponentContext jbiContext) throws Exception {
        Context ctx = (Context)jmsContext;
        MessageExchange exchange = jbiContext.getDeliveryChannel().createExchangeFactory().createExchange(this.mep);
        NormalizedMessage inMessage = exchange.createMessage();
        this.populateMessage(ctx.message, inMessage);
        exchange.setMessage(inMessage, "in");
        return exchange;
    }

    public Message createOut(MessageExchange exchange, NormalizedMessage outMsg, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        String text = new SourceTransformer().contentToString(outMsg);
        return session.createTextMessage(text);
    }

    public Message createFault(MessageExchange exchange, Fault fault, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        String text = new SourceTransformer().contentToString((NormalizedMessage)fault);
        return session.createTextMessage(text);
    }

    public Message createError(MessageExchange exchange, Exception error, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        throw error;
    }

    protected void populateMessage(Message message, NormalizedMessage normalizedMessage) throws Exception {
        if (!(message instanceof TextMessage)) {
            throw new UnsupportedOperationException("JMS message is not a TextMessage");
        }
        TextMessage textMessage = (TextMessage)message;
        StringSource source = new StringSource(textMessage.getText());
        normalizedMessage.setContent((Source)source);
    }

    protected static class Context
    implements JmsConsumerMarshaler.JmsContext,
    Serializable {
        Message message;

        Context(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.message);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.message = (Message)in.readObject();
        }
    }
}

