/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Source;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jms.endpoints.JmsProviderMarshaler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProviderMarshaler
implements JmsProviderMarshaler {
    private Map<String, Object> jmsProperties;
    private SourceTransformer transformer = new SourceTransformer();

    public Map<String, Object> getJmsProperties() {
        return this.jmsProperties;
    }

    public void setJmsProperties(Map<String, Object> jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    @Override
    public Message createMessage(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        TextMessage text = session.createTextMessage();
        text.setText(this.transformer.contentToString(in));
        if (this.jmsProperties != null) {
            for (Map.Entry<String, Object> e : this.jmsProperties.entrySet()) {
                text.setObjectProperty(e.getKey(), e.getValue());
            }
        }
        return text;
    }

    @Override
    public void populateMessage(Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception {
        if (!(message instanceof TextMessage)) {
            throw new UnsupportedOperationException("JMS message is not a TextMessage");
        }
        TextMessage textMessage = (TextMessage)message;
        StringSource source = new StringSource(textMessage.getText());
        normalizedMessage.setContent((Source)source);
    }
}

