/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jms.JmsEndpointType;
import org.apache.servicemix.jms.endpoints.DefaultProviderMarshaler;
import org.apache.servicemix.jms.endpoints.DestinationChooser;
import org.apache.servicemix.jms.endpoints.JmsProviderMarshaler;
import org.apache.servicemix.jms.endpoints.SimpleDestinationChooser;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.JmsTemplate102;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer102;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class JmsProviderEndpoint
extends ProviderEndpoint
implements JmsEndpointType {
    private static final String MSG_SELECTOR_START = "JMSCorrelationID='";
    private static final String MSG_SELECTOR_END = "'";
    private JmsProviderMarshaler marshaler = new DefaultProviderMarshaler();
    private DestinationChooser destinationChooser = new SimpleDestinationChooser();
    private DestinationChooser replyDestinationChooser = new SimpleDestinationChooser();
    private JmsTemplate template;
    private boolean jms102;
    private ConnectionFactory connectionFactory;
    private boolean pubSubDomain;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private Destination destination;
    private String destinationName;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean pubSubNoLocal;
    private long receiveTimeout = 0L;
    private boolean explicitQosEnabled;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private Destination replyDestination;
    private String replyDestinationName;
    private StoreFactory storeFactory;
    private Store store;
    private AbstractMessageListenerContainer listenerContainer;

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isJms102() {
        return this.jms102;
    }

    public void setJms102(boolean jms102) {
        this.jms102 = jms102;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        if (destinationChooser == null) {
            throw new NullPointerException("destinationChooser is null");
        }
        this.destinationChooser = destinationChooser;
    }

    public DestinationChooser getReplyDestinationChooser() {
        return this.replyDestinationChooser;
    }

    public void setReplyDestinationChooser(DestinationChooser replyDestinationChooser) {
        this.replyDestinationChooser = replyDestinationChooser;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public JmsProviderMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsProviderMarshaler marshaler) {
        if (marshaler == null) {
            throw new NullPointerException("marshaler is null");
        }
        this.marshaler = marshaler;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public Destination getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getReplyDestinationName() {
        return this.replyDestinationName;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() != MessageExchange.Role.PROVIDER) throw new IllegalStateException("Unsupported role: " + exchange.getRole());
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            this.done(exchange);
            return;
        } else {
            NormalizedMessage in = exchange.getMessage("in");
            if (in == null) throw new IllegalStateException("Provider exchange is ACTIVE, but no in or fault is provided");
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                this.processInOnly(exchange, in);
                this.done(exchange);
                return;
            } else {
                this.processInOut(exchange, in);
            }
        }
    }

    protected void processInOnly(final MessageExchange exchange, final NormalizedMessage in) throws Exception {
        SessionCallback callback = new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                try {
                    JmsProviderEndpoint.this.processInOnlyInSession(exchange, in, session);
                    return null;
                }
                catch (JMSException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UncategorizedJmsException((Throwable)e);
                }
            }
        };
        this.template.execute(callback, true);
    }

    protected void processInOnlyInSession(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        Destination dest = this.getDestination(exchange, in, session);
        final Message message = this.marshaler.createMessage(exchange, in, session);
        this.template.send(dest, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return message;
            }
        });
    }

    protected void processInOut(final MessageExchange exchange, final NormalizedMessage in) throws Exception {
        SessionCallback callback = new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                try {
                    JmsProviderEndpoint.this.processInOutInSession(exchange, in, session);
                    return null;
                }
                catch (JMSException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UncategorizedJmsException((Throwable)e);
                }
            }
        };
        this.template.execute(callback, true);
    }

    protected void processInOutInSession(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        Destination dest = this.getDestination(exchange, in, session);
        Destination replyDest = this.getReplyDestination(exchange, in, session);
        final Message sendJmsMsg = this.marshaler.createMessage(exchange, in, session);
        sendJmsMsg.setJMSReplyTo(replyDest);
        String correlationId = sendJmsMsg.getJMSMessageID() != null ? sendJmsMsg.getJMSMessageID() : exchange.getExchangeId();
        sendJmsMsg.setJMSCorrelationID(correlationId);
        boolean asynchronous = replyDest.equals(this.replyDestination);
        if (asynchronous) {
            this.store.store(correlationId, (Object)exchange);
        }
        try {
            this.template.send(dest, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return sendJmsMsg;
                }
            });
        }
        catch (Exception e) {
            if (asynchronous) {
                this.store.load(exchange.getExchangeId());
            }
            throw e;
        }
        if (!asynchronous) {
            boolean txSync;
            String jmsId = sendJmsMsg.getJMSMessageID();
            String selector = MSG_SELECTOR_START + jmsId + MSG_SELECTOR_END;
            Message receiveJmsMsg = this.template.receiveSelected(replyDest, selector);
            if (receiveJmsMsg == null) {
                throw new IllegalStateException("Unable to receive response");
            }
            NormalizedMessage out = exchange.getMessage("out");
            if (out == null) {
                out = exchange.createMessage();
                exchange.setMessage(out, "out");
            }
            this.marshaler.populateMessage(receiveJmsMsg, exchange, out);
            boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        }
    }

    protected void onMessage(Message message) {
        InOut exchange = null;
        try {
            exchange = (InOut)this.store.load(message.getJMSCorrelationID());
            if (exchange == null) {
                throw new IllegalStateException("Could not find exchange " + message.getJMSCorrelationID());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to load exchange related to incoming JMS message " + message), (Throwable)e);
        }
        try {
            NormalizedMessage out = exchange.getMessage("out");
            if (out == null) {
                out = exchange.createMessage();
                exchange.setMessage(out, "out");
            }
            this.marshaler.populateMessage(message, (MessageExchange)exchange, out);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Error while populating JBI exchange " + exchange), (Throwable)e);
            }
            exchange.setError(e);
        }
        try {
            boolean txSync;
            boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync((MessageExchange)exchange);
            } else {
                this.send((MessageExchange)exchange);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to send JBI exchange " + exchange), (Throwable)e);
        }
    }

    protected Destination getDestination(MessageExchange exchange, Object message, Session session) throws JMSException {
        return this.chooseDestination(exchange, message, session, this.destinationChooser, this.destination);
    }

    protected Destination getReplyDestination(MessageExchange exchange, Object message, Session session) throws JMSException {
        return this.chooseDestination(exchange, message, session, this.replyDestinationChooser, this.replyDestination);
    }

    protected Destination chooseDestination(MessageExchange exchange, Object message, Session session, DestinationChooser chooser, Destination defaultDestination) throws JMSException {
        Object dest = null;
        if (chooser != null) {
            dest = chooser.chooseDestination(exchange, message);
        }
        if (dest == null) {
            dest = defaultDestination;
        }
        if (dest instanceof Destination) {
            return dest;
        }
        if (dest instanceof String) {
            return this.destinationResolver.resolveDestinationName(session, (String)dest, this.isPubSubDomain());
        }
        throw new IllegalStateException("Unable to choose a destination for exchange " + exchange);
    }

    public synchronized void activate() throws Exception {
        super.activate();
        if (this.store == null) {
            if (this.storeFactory == null) {
                this.storeFactory = new MemoryStoreFactory();
            }
            this.store = this.storeFactory.open(this.getService().toString() + this.getEndpoint());
        }
        this.template = this.createTemplate();
        if (this.destination == null && this.destinationName != null) {
            this.destination = (Destination)this.template.execute(new SessionCallback(){

                public Object doInJms(Session session) throws JMSException {
                    return JmsProviderEndpoint.this.destinationResolver.resolveDestinationName(session, JmsProviderEndpoint.this.destinationName, JmsProviderEndpoint.this.isPubSubDomain());
                }
            });
        }
        if (this.replyDestination == null && this.replyDestinationName != null) {
            this.replyDestination = (Destination)this.template.execute(new SessionCallback(){

                public Object doInJms(Session session) throws JMSException {
                    return JmsProviderEndpoint.this.destinationResolver.resolveDestinationName(session, JmsProviderEndpoint.this.replyDestinationName, JmsProviderEndpoint.this.isPubSubDomain());
                }
            });
        }
        if (this.replyDestination != null) {
            this.listenerContainer = this.createListenerContainer();
            this.listenerContainer.start();
        }
    }

    public synchronized void deactivate() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.shutdown();
        }
        if (this.store != null) {
            if (this.storeFactory != null) {
                this.storeFactory.close(this.store);
            }
            this.store = null;
        }
        super.deactivate();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.getService() == null) {
            throw new DeploymentException("service must be set");
        }
        if (this.getEndpoint() == null) {
            throw new DeploymentException("endpoint must be set");
        }
        if (this.getConnectionFactory() == null) {
            throw new DeploymentException("connectionFactory is required");
        }
    }

    protected JmsTemplate createTemplate() {
        Object tplt = this.isJms102() ? new JmsTemplate102() : new JmsTemplate();
        tplt.setConnectionFactory(this.getConnectionFactory());
        if (this.getDestination() != null) {
            tplt.setDefaultDestination(this.getDestination());
        } else if (this.getDestinationName() != null) {
            tplt.setDefaultDestinationName(this.getDestinationName());
        }
        tplt.setDeliveryMode(this.getDeliveryMode());
        if (this.getDestinationResolver() != null) {
            tplt.setDestinationResolver(this.getDestinationResolver());
        }
        tplt.setExplicitQosEnabled(this.isExplicitQosEnabled());
        tplt.setMessageIdEnabled(this.isMessageIdEnabled());
        tplt.setMessageTimestampEnabled(this.isMessageTimestampEnabled());
        tplt.setPriority(this.getPriority());
        tplt.setPubSubDomain(this.isPubSubDomain());
        tplt.setPubSubNoLocal(this.isPubSubNoLocal());
        tplt.setTimeToLive(this.getTimeToLive());
        tplt.setReceiveTimeout(this.getReceiveTimeout());
        tplt.afterPropertiesSet();
        return tplt;
    }

    protected AbstractMessageListenerContainer createListenerContainer() {
        Object cont = this.isJms102() ? new DefaultMessageListenerContainer102() : new DefaultMessageListenerContainer();
        cont.setConnectionFactory(this.getConnectionFactory());
        cont.setDestination(this.getReplyDestination());
        cont.setPubSubDomain(this.isPubSubDomain());
        cont.setPubSubNoLocal(this.isPubSubNoLocal());
        cont.setMessageListener((Object)new MessageListener(){

            public void onMessage(Message message) {
                JmsProviderEndpoint.this.onMessage(message);
            }
        });
        cont.setAutoStartup(false);
        cont.afterPropertiesSet();
        return cont;
    }
}

