/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrefetchSubscription
extends AbstractSubscription {
    private static final Log LOG = LogFactory.getLog(PrefetchSubscription.class);
    protected PendingMessageCursor pending;
    protected final List<MessageReference> dispatched = new CopyOnWriteArrayList<MessageReference>();
    protected int prefetchExtension;
    protected long enqueueCounter;
    protected long dispatchCounter;
    protected long dequeueCounter;
    private int maxProducersToAudit = 32;
    private int maxAuditDepth = 2048;
    protected final SystemUsage usageManager;
    private final Object pendingLock = new Object();
    private final Object dispatchLock = new Object();
    protected ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
    private boolean slowConsumer;

    public PrefetchSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info, PendingMessageCursor cursor) throws InvalidSelectorException {
        super(broker, context, info);
        this.usageManager = usageManager;
        this.pending = cursor;
    }

    public PrefetchSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this(broker, usageManager, context, info, new VMPendingMessageCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response pullMessage(ConnectionContext context, MessagePull pull) throws Exception {
        if (this.getPrefetchSize() == 0 && !this.isSlave()) {
            long dispatchCounterBeforePull;
            PrefetchSubscription prefetchSubscription = this;
            synchronized (prefetchSubscription) {
                ++this.prefetchExtension;
                dispatchCounterBeforePull = this.dispatchCounter;
            }
            for (Destination dest : this.destinations) {
                dest.iterate();
            }
            this.dispatchPending();
            prefetchSubscription = this;
            synchronized (prefetchSubscription) {
                if (dispatchCounterBeforePull == this.dispatchCounter) {
                    if (pull.getTimeout() == -1L) {
                        this.add(QueueMessageReference.NULL_MESSAGE);
                        this.dispatchPending();
                    }
                    if (pull.getTimeout() > 0L) {
                        Scheduler.executeAfterDelay(new Runnable(){

                            public void run() {
                                PrefetchSubscription.this.pullTimeout(dispatchCounterBeforePull);
                            }
                        }, pull.getTimeout());
                    }
                }
            }
        }
        return null;
    }

    final synchronized void pullTimeout(long dispatchCounterBeforePull) {
        if (dispatchCounterBeforePull == this.dispatchCounter) {
            try {
                this.add(QueueMessageReference.NULL_MESSAGE);
                this.dispatchPending();
            }
            catch (Exception e) {
                this.context.getConnection().serviceException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageReference node) throws Exception {
        Object object = this.pendingLock;
        synchronized (object) {
            if (!this.destinations.contains(node.getRegionDestination()) && node != QueueMessageReference.NULL_MESSAGE) {
                return;
            }
            ++this.enqueueCounter;
            this.pending.addMessageLast(node);
        }
        this.dispatchPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessageDispatchNotification(MessageDispatchNotification mdn) throws Exception {
        Object object = this.pendingLock;
        synchronized (object) {
            try {
                this.pending.reset();
                while (true) {
                    if (!this.pending.hasNext()) break;
                    MessageReference node = this.pending.next();
                    if (!node.getMessageId().equals(mdn.getMessageId())) continue;
                    this.pending.remove();
                    this.createMessageDispatch(node, node.getMessage());
                    Object object2 = this.dispatchLock;
                    synchronized (object2) {
                        this.dispatched.add(node);
                    }
                    return;
                }
            }
            finally {
                this.pending.release();
            }
        }
        throw new JMSException("Slave broker out of sync with master: Dispatched message (" + mdn.getMessageId() + ") was not in the pending list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        boolean callDispatchMatched = false;
        Destination destination = null;
        Object object = this.dispatchLock;
        synchronized (object) {
            if (ack.isStandardAck()) {
                int index = 0;
                boolean inAckRange = false;
                ArrayList<MessageReference> removeList = new ArrayList<MessageReference>();
                for (final MessageReference node : this.dispatched) {
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    if (!context.isInTransaction()) {
                        ++this.dequeueCounter;
                        node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                        if (!this.isSlave()) {
                            node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                        }
                        removeList.add(node);
                    } else {
                        context.getTransaction().addSynchronization(new Synchronization(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void afterCommit() throws Exception {
                                Object object = PrefetchSubscription.this.dispatchLock;
                                synchronized (object) {
                                    ++PrefetchSubscription.this.dequeueCounter;
                                    PrefetchSubscription.this.dispatched.remove(node);
                                    node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                                    --PrefetchSubscription.this.prefetchExtension;
                                }
                            }

                            public void afterRollback() throws Exception {
                                super.afterRollback();
                            }
                        });
                    }
                    ++index;
                    this.acknowledge(context, ack, node);
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    if (context.isInTransaction()) {
                        if (this.getPrefetchSize() != 0) {
                            this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                        }
                    } else {
                        this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                    }
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
                for (final MessageReference node : removeList) {
                    this.dispatched.remove(node);
                }
                if (!callDispatchMatched && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Could not correlate acknowledgment with dispatched message: " + ack));
                }
            } else if (ack.isIndividualAck()) {
                for (MessageReference node : this.dispatched) {
                    MessageId messageId = node.getMessageId();
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                    node.getRegionDestination().getDestinationStatistics().getInflight().decrement();
                    destination = node.getRegionDestination();
                    this.acknowledge(context, ack, node);
                    this.dispatched.remove(node);
                    this.prefetchExtension = Math.max(0, this.prefetchExtension - 1);
                    callDispatchMatched = true;
                    break;
                }
            } else if (ack.isDeliveredAck()) {
                int index = 0;
                for (MessageReference node : this.dispatched) {
                    if (node.isExpired()) {
                        node.getRegionDestination().messageExpired(context, this, node);
                        this.dispatched.remove(node);
                    }
                    if (ack.getLastMessageId().equals(node.getMessageId())) {
                        this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                        destination = node.getRegionDestination();
                        callDispatchMatched = true;
                        break;
                    }
                    ++index;
                }
                if (!callDispatchMatched) {
                    throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            } else if (ack.isRedeliveredAck()) {
                boolean inAckRange = false;
                for (MessageReference node : this.dispatched) {
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    node.incrementRedeliveryCounter();
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
                if (!callDispatchMatched) {
                    throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            } else if (ack.isPoisonAck()) {
                if (ack.isInTransaction()) {
                    throw new JMSException("Poison ack cannot be transacted: " + ack);
                }
                int index = 0;
                boolean inAckRange = false;
                ArrayList<MessageReference> removeList = new ArrayList<MessageReference>();
                for (MessageReference node : this.dispatched) {
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    this.sendToDLQ(context, node);
                    node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                    removeList.add(node);
                    ++this.dequeueCounter;
                    ++index;
                    this.acknowledge(context, ack, node);
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                    destination = node.getRegionDestination();
                    callDispatchMatched = true;
                    break;
                }
                for (MessageReference node : removeList) {
                    this.dispatched.remove(node);
                }
                if (!callDispatchMatched) {
                    throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
                }
            }
        }
        if (callDispatchMatched && destination != null) {
            destination.wakeup();
            this.dispatchPending();
        } else {
            if (this.isSlave()) {
                throw new JMSException("Slave broker out of sync with master: Acknowledgment (" + ack + ") was not in the dispatch list: " + this.dispatched);
            }
            LOG.debug((Object)("Acknowledgment out of sync (Normally occurs when failover connection reconnects): " + ack));
        }
    }

    protected void sendToDLQ(ConnectionContext context, MessageReference node) throws IOException, Exception {
        this.broker.sendToDeadLetterQueue(context, node);
    }

    @Override
    public int getInFlightSize() {
        return this.dispatched.size();
    }

    @Override
    public boolean isFull() {
        return this.isSlave() || this.dispatched.size() - this.prefetchExtension >= this.info.getPrefetchSize();
    }

    @Override
    public boolean isLowWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) <= (double)this.info.getPrefetchSize() * 0.4;
    }

    @Override
    public boolean isHighWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) >= (double)this.info.getPrefetchSize() * 0.9;
    }

    @Override
    public int countBeforeFull() {
        return this.info.getPrefetchSize() + this.prefetchExtension - this.dispatched.size();
    }

    @Override
    public int getPendingQueueSize() {
        return this.pending.size();
    }

    @Override
    public int getDispatchedQueueSize() {
        return this.dispatched.size();
    }

    @Override
    public long getDequeueCounter() {
        return this.dequeueCounter;
    }

    @Override
    public long getDispatchedCounter() {
        return this.dispatchCounter;
    }

    @Override
    public long getEnqueueCounter() {
        return this.enqueueCounter;
    }

    @Override
    public boolean isRecoveryRequired() {
        return this.pending.isRecoveryRequired();
    }

    public PendingMessageCursor getPending() {
        return this.pending;
    }

    public void setPending(PendingMessageCursor pending) {
        this.pending = pending;
        if (this.pending != null) {
            this.pending.setSystemUsage(this.usageManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ConnectionContext context, Destination destination) throws Exception {
        Object object = this.pendingLock;
        synchronized (object) {
            super.add(context, destination);
            this.pending.add(context, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        ArrayList<MessageReference> rc = new ArrayList<MessageReference>();
        Object object = this.pendingLock;
        synchronized (object) {
            super.remove(context, destination);
            for (MessageReference r : this.dispatched) {
                if (r.getRegionDestination() != destination) continue;
                rc.add((QueueMessageReference)r);
            }
            rc.addAll(this.pending.remove(context, destination));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchPending() throws IOException {
        if (!this.isSlave()) {
            Object object = this.pendingLock;
            synchronized (object) {
                block13: {
                    try {
                        int numberToDispatch = this.countBeforeFull();
                        if (numberToDispatch > 0) {
                            this.slowConsumer = false;
                            this.pending.setMaxBatchSize(numberToDispatch);
                            int count = 0;
                            this.pending.reset();
                            while (this.pending.hasNext() && !this.isFull() && count < numberToDispatch) {
                                MessageReference node = this.pending.next();
                                if (node == null) {
                                    break block13;
                                }
                                this.pending.remove();
                                if (this.isDropped(node) || !this.canDispatch(node)) continue;
                                if (node != QueueMessageReference.NULL_MESSAGE && node.isExpired()) {
                                    ++numberToDispatch;
                                    node.getRegionDestination().messageExpired(this.context, this, node);
                                    continue;
                                }
                                this.dispatch(node);
                                ++count;
                            }
                            break block13;
                        }
                        if (!this.slowConsumer) {
                            this.slowConsumer = true;
                            ConnectionContext c = new ConnectionContext();
                            c.setBroker(this.context.getBroker());
                            for (Destination dest : this.destinations) {
                                dest.slowConsumer(c, this);
                            }
                        }
                    }
                    finally {
                        this.pending.release();
                    }
                }
            }
        }
    }

    protected boolean dispatch(final MessageReference node) throws IOException {
        final Message message = node.getMessage();
        if (message == null) {
            return false;
        }
        if (this.canDispatch(node) && !this.isSlave()) {
            MessageDispatch md = this.createMessageDispatch(node, message);
            if (node != QueueMessageReference.NULL_MESSAGE) {
                ++this.dispatchCounter;
                this.dispatched.add(node);
            } else {
                this.prefetchExtension = Math.max(0, this.prefetchExtension - 1);
            }
            if (this.info.isDispatchAsync()) {
                md.setTransmitCallback(new Runnable(){

                    public void run() {
                        PrefetchSubscription.this.onDispatch(node, message);
                    }
                });
                this.context.getConnection().dispatchAsync(md);
            } else {
                this.context.getConnection().dispatchSync(md);
                this.onDispatch(node, message);
            }
            return true;
        }
        return false;
    }

    protected void onDispatch(MessageReference node, Message message) {
        if (node.getRegionDestination() != null && node != QueueMessageReference.NULL_MESSAGE) {
            node.getRegionDestination().getDestinationStatistics().getDispatched().increment();
            node.getRegionDestination().getDestinationStatistics().getInflight().increment();
        }
        if (this.info.isDispatchAsync()) {
            try {
                this.dispatchPending();
            }
            catch (IOException e) {
                this.context.getConnection().serviceExceptionAsync(e);
            }
        }
    }

    @Override
    public void updateConsumerPrefetch(int newPrefetch) {
        if (this.context != null && this.context.getConnection() != null && this.context.getConnection().isManageable()) {
            ConsumerControl cc = new ConsumerControl();
            cc.setConsumerId(this.info.getConsumerId());
            cc.setPrefetch(newPrefetch);
            this.context.getConnection().dispatchAsync(cc);
        }
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        if (node == QueueMessageReference.NULL_MESSAGE) {
            MessageDispatch md = new MessageDispatch();
            md.setMessage(null);
            md.setConsumerId(this.info.getConsumerId());
            md.setDestination(null);
            return md;
        }
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setDestination(node.getRegionDestination().getActiveMQDestination());
        md.setMessage(message);
        md.setRedeliveryCounter(node.getRedeliveryCounter());
        return md;
    }

    protected abstract boolean canDispatch(MessageReference var1) throws IOException;

    protected abstract boolean isDropped(MessageReference var1);

    protected abstract void acknowledge(ConnectionContext var1, MessageAck var2, MessageReference var3) throws IOException;

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }
}

