/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.usage.SystemUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPendingMessageCursor
implements PendingMessageCursor {
    protected int memoryUsageHighWaterMark = 70;
    protected int maxBatchSize = 100;
    protected SystemUsage systemUsage;
    protected int maxProducersToAudit = 1024;
    protected int maxAuditDepth = 1000;
    protected boolean enableAudit = true;
    protected ActiveMQMessageAudit audit;
    protected boolean useCache = false;
    private boolean started = false;

    @Override
    public synchronized void start() throws Exception {
        if (!this.started && this.enableAudit && this.audit == null) {
            this.audit = new ActiveMQMessageAudit(this.maxAuditDepth, this.maxProducersToAudit);
        }
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        this.started = false;
        this.audit = null;
        this.gc();
    }

    @Override
    public void add(ConnectionContext context, Destination destination) throws Exception {
    }

    @Override
    public List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isRecoveryRequired() {
        return true;
    }

    @Override
    public void addMessageFirst(MessageReference node) throws Exception {
    }

    @Override
    public void addMessageLast(MessageReference node) throws Exception {
    }

    @Override
    public void addRecoveredMessage(MessageReference node) throws Exception {
        this.addMessageLast(node);
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEmpty(Destination destination) {
        return this.isEmpty();
    }

    @Override
    public MessageReference next() {
        return null;
    }

    @Override
    public void remove() {
    }

    @Override
    public void reset() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    protected void fillBatch() throws Exception {
    }

    @Override
    public void resetForGC() {
        this.reset();
    }

    @Override
    public void remove(MessageReference node) {
    }

    @Override
    public void gc() {
    }

    @Override
    public void setSystemUsage(SystemUsage usageManager) {
        this.systemUsage = usageManager;
    }

    @Override
    public boolean hasSpace() {
        return this.systemUsage != null ? this.systemUsage.getMemoryUsage().getPercentUsage() < this.memoryUsageHighWaterMark : true;
    }

    @Override
    public boolean isFull() {
        return this.systemUsage != null ? this.systemUsage.getMemoryUsage().isFull() : false;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean hasMessagesBufferedToDeliver() {
        return false;
    }

    @Override
    public int getMemoryUsageHighWaterMark() {
        return this.memoryUsageHighWaterMark;
    }

    @Override
    public void setMemoryUsageHighWaterMark(int memoryUsageHighWaterMark) {
        this.memoryUsageHighWaterMark = memoryUsageHighWaterMark;
    }

    @Override
    public SystemUsage getSystemUsage() {
        return this.systemUsage;
    }

    @Override
    public void destroy() throws Exception {
        this.stop();
    }

    public LinkedList pageInList(int maxItems) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    @Override
    public synchronized void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
        if (this.audit != null) {
            this.audit.setMaximumNumberOfProducersToTrack(maxProducersToAudit);
        }
    }

    @Override
    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    @Override
    public synchronized void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
        if (this.audit != null) {
            this.audit.setAuditDepth(maxAuditDepth);
        }
    }

    @Override
    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    @Override
    public synchronized void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
        if (this.enableAudit && this.started && this.audit == null) {
            this.audit = new ActiveMQMessageAudit(this.maxAuditDepth, this.maxProducersToAudit);
        }
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void dispatched(MessageReference message) {
        this.isDuplicate(message.getMessageId());
    }

    @Override
    public void setMessageAudit(ActiveMQMessageAudit audit) {
        this.audit = audit;
    }

    @Override
    public ActiveMQMessageAudit getMessageAudit() {
        return this.audit;
    }

    @Override
    public boolean isUseCache() {
        return this.useCache;
    }

    @Override
    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    protected synchronized boolean isDuplicate(MessageId messageId) {
        if (!this.enableAudit || this.audit == null) {
            return false;
        }
        return this.audit.isDuplicate(messageId);
    }

    protected synchronized void rollback(MessageId id) {
        if (this.audit != null) {
            this.audit.rollback(id);
        }
    }

    protected synchronized boolean isStarted() {
        return this.started;
    }
}

