/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import org.apache.activemq.broker.region.policy.AbstractDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class IndividualDeadLetterStrategy
extends AbstractDeadLetterStrategy {
    private String topicPrefix = "ActiveMQ.DLQ.Topic.";
    private String queuePrefix = "ActiveMQ.DLQ.Queue.";
    private boolean useQueueForQueueMessages = true;
    private boolean useQueueForTopicMessages = true;

    public ActiveMQDestination getDeadLetterQueueFor(ActiveMQDestination originalDestination) {
        if (originalDestination.isQueue()) {
            return this.createDestination(originalDestination, this.queuePrefix, this.useQueueForQueueMessages);
        }
        return this.createDestination(originalDestination, this.topicPrefix, this.useQueueForTopicMessages);
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public boolean isUseQueueForQueueMessages() {
        return this.useQueueForQueueMessages;
    }

    public void setUseQueueForQueueMessages(boolean useQueueForQueueMessages) {
        this.useQueueForQueueMessages = useQueueForQueueMessages;
    }

    public boolean isUseQueueForTopicMessages() {
        return this.useQueueForTopicMessages;
    }

    public void setUseQueueForTopicMessages(boolean useQueueForTopicMessages) {
        this.useQueueForTopicMessages = useQueueForTopicMessages;
    }

    protected ActiveMQDestination createDestination(ActiveMQDestination originalDestination, String prefix, boolean useQueue) {
        String name = prefix + originalDestination.getPhysicalName();
        if (useQueue) {
            return new ActiveMQQueue(name);
        }
        return new ActiveMQTopic(name);
    }
}

