/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ConsumerListener;
import org.apache.activemq.group.EntryKey;
import org.apache.activemq.group.EntryMessage;
import org.apache.activemq.group.EntryValue;
import org.apache.activemq.group.IllegalAccessException;
import org.apache.activemq.group.MapChangedListener;
import org.apache.activemq.group.MapRequest;
import org.apache.activemq.group.Member;
import org.apache.activemq.group.MemberChangedListener;
import org.apache.activemq.thread.SchedulerTimerTask;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LRUSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMap<K, V>
implements Map<K, V>,
Service {
    private static final Log LOG = LogFactory.getLog(GroupMap.class);
    private static final String STATE_TOPIC_PREFIX = GroupMap.class.getName() + ".";
    private static final int HEART_BEAT_INTERVAL = 15000;
    private final Object mapMutex = new Object();
    private Map<EntryKey<K>, EntryValue<V>> localMap;
    private Map<String, Member> members = new ConcurrentHashMap<String, Member>();
    private Map<String, MapRequest> requests = new HashMap<String, MapRequest>();
    private List<MemberChangedListener> membershipListeners = new CopyOnWriteArrayList<MemberChangedListener>();
    private List<MapChangedListener> mapChangedListeners = new CopyOnWriteArrayList<MapChangedListener>();
    private LRUSet<Message> mapUpdateReplies = new LRUSet();
    private Member local;
    private Member coordinator;
    private String groupName;
    private boolean sharedWrites;
    private Connection connection;
    private Session session;
    private Topic topic;
    private Topic heartBeatTopic;
    private Topic inboxTopic;
    private MessageProducer producer;
    private ConsumerEventSource consumerEvents;
    private AtomicBoolean started = new AtomicBoolean();
    private SchedulerTimerTask heartBeatTask;
    private SchedulerTimerTask checkMembershipTask;
    private Timer heartBeatTimer;
    private int heartBeatInterval = 15000;
    private IdGenerator requestGenerator = new IdGenerator();
    private boolean removeOwnedObjectsOnExit;

    public GroupMap(Connection connection, String name) {
        this(connection, "default", name);
    }

    public GroupMap(Connection connection, String groupName, String name) {
        this.connection = connection;
        this.coordinator = this.local = new Member(name);
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalMap(Map map) {
        Object object = this.mapMutex;
        synchronized (object) {
            this.localMap = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            Object object = this.mapMutex;
            synchronized (object) {
                if (this.localMap == null) {
                    this.localMap = new HashMap<EntryKey<K>, EntryValue<V>>();
                }
            }
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer(null);
            this.producer.setDeliveryMode(1);
            this.inboxTopic = this.session.createTemporaryTopic();
            String topicName = STATE_TOPIC_PREFIX + this.groupName;
            this.topic = this.session.createTopic(topicName);
            this.heartBeatTopic = this.session.createTopic(topicName + ".heartbeat");
            MessageConsumer privateInbox = this.session.createConsumer((Destination)this.inboxTopic);
            privateInbox.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    GroupMap.this.handleResponses(message);
                }
            });
            ActiveMQMessageConsumer mapChangeConsumer = (ActiveMQMessageConsumer)this.session.createConsumer((Destination)this.topic);
            mapChangeConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    GroupMap.this.handleMapUpdates(message);
                }
            });
            MessageConsumer heartBeatConsumer = this.session.createConsumer((Destination)this.heartBeatTopic);
            heartBeatConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    GroupMap.this.handleHeartbeats(message);
                }
            });
            this.consumerEvents = new ConsumerEventSource(this.connection, (Destination)this.topic);
            this.consumerEvents.setConsumerListener(new ConsumerListener(){

                public void onConsumerEvent(ConsumerEvent event) {
                    GroupMap.this.handleConsumerEvents(event);
                }
            });
            this.consumerEvents.start();
            this.local.setId(mapChangeConsumer.getConsumerId().toString());
            this.local.setInBoxDestination((Destination)this.inboxTopic);
            this.sendHeartBeat();
            this.heartBeatTask = new SchedulerTimerTask(new Runnable(){

                public void run() {
                    GroupMap.this.sendHeartBeat();
                }
            });
            this.checkMembershipTask = new SchedulerTimerTask(new Runnable(){

                public void run() {
                    GroupMap.this.checkMembership();
                }
            });
            this.heartBeatTimer = new Timer("Distributed heart beat", true);
            this.heartBeatTimer.scheduleAtFixedRate((TimerTask)this.heartBeatTask, this.getHeartBeatInterval() / 3, (long)(this.getHeartBeatInterval() / 2));
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.checkMembershipTask.cancel();
            this.heartBeatTask.cancel();
            this.heartBeatTimer.purge();
            this.consumerEvents.stop();
            this.session.close();
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isSharedWrites() {
        return this.sharedWrites;
    }

    public void setSharedWrites(boolean sharedWrites) {
        this.sharedWrites = sharedWrites;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(int heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public void addMemberChangedListener(MemberChangedListener l) {
        this.membershipListeners.add(l);
    }

    public void removeMemberChangedListener(MemberChangedListener l) {
        this.membershipListeners.remove(l);
    }

    public void addMapChangedListener(MapChangedListener l) {
        this.mapChangedListeners.add(l);
    }

    public void removeMapChangedListener(MapChangedListener l) {
        this.mapChangedListeners.remove(l);
    }

    public boolean isRemoveOwnedObjectsOnExit() {
        return this.removeOwnedObjectsOnExit;
    }

    public void setRemoveOwnedObjectsOnExit(boolean removeOwnedObjectsOnExit) {
        this.removeOwnedObjectsOnExit = removeOwnedObjectsOnExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IllegalStateException {
        this.checkStarted();
        if (this.localMap != null && !this.localMap.isEmpty()) {
            HashSet<EntryKey<K>> keys = null;
            Object object = this.mapMutex;
            synchronized (object) {
                keys = new HashSet<EntryKey<K>>(this.localMap.keySet());
                this.localMap.clear();
            }
            for (EntryKey entryKey : keys) {
                this.remove(entryKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        EntryKey<Object> stateKey = new EntryKey<Object>(this.local, key);
        Object object = this.mapMutex;
        synchronized (object) {
            return this.localMap != null ? this.localMap.containsKey(stateKey) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        EntryValue<Object> entryValue = new EntryValue<Object>(this.local, value);
        Object object = this.mapMutex;
        synchronized (object) {
            return this.localMap != null ? this.localMap.containsValue(entryValue) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> result = new HashMap<K, V>();
        Object object = this.mapMutex;
        synchronized (object) {
            if (this.localMap != null) {
                for (Map.Entry<EntryKey<K>, EntryValue<V>> entry : this.localMap.entrySet()) {
                    result.put(entry.getKey().getKey(), entry.getValue().getValue());
                }
            }
        }
        return result.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        EntryKey<Object> stateKey = new EntryKey<Object>(this.local, key);
        EntryValue<V> value = null;
        Object object = this.mapMutex;
        synchronized (object) {
            value = this.localMap != null ? this.localMap.get(stateKey) : null;
        }
        return value != null ? (V)value.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mapMutex;
        synchronized (object) {
            return this.localMap != null ? this.localMap.isEmpty() : true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>();
        Object object = this.mapMutex;
        synchronized (object) {
            if (this.localMap != null) {
                for (EntryKey<K> key : this.localMap.keySet()) {
                    result.add(key.getKey());
                }
            }
        }
        return result;
    }

    @Override
    public V put(K key, V value) throws IllegalAccessException, IllegalStateException {
        return this.put(key, value, this.isSharedWrites(), this.isRemoveOwnedObjectsOnExit());
    }

    public V put(K key, V value, boolean sharedWrites, boolean removeOnExit) throws IllegalAccessException, IllegalStateException {
        this.checkStarted();
        EntryKey<K> entryKey = new EntryKey<K>(this.local, key);
        EntryValue<V> stateValue = new EntryValue<V>(this.local, value);
        entryKey.setShare(sharedWrites);
        entryKey.setRemoveOnExit(removeOnExit);
        EntryMessage entryMsg = new EntryMessage();
        entryMsg.setKey(entryKey);
        entryMsg.setValue(value);
        entryMsg.setType(EntryMessage.MessageType.INSERT);
        return this.sendEntryMessage(entryMsg);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws IllegalAccessException, IllegalStateException {
        this.putAll(t, this.isSharedWrites(), this.isRemoveOwnedObjectsOnExit());
    }

    public void putAll(Map<? extends K, ? extends V> t, boolean sharedWrites, boolean removeOnExit) throws IllegalAccessException, IllegalStateException {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), sharedWrites, removeOnExit);
        }
    }

    @Override
    public V remove(Object key) throws IllegalAccessException, IllegalStateException {
        EntryKey<Object> entryKey = new EntryKey<Object>(this.local, key);
        return this.remove(entryKey);
    }

    V remove(EntryKey<K> key) throws IllegalAccessException, IllegalStateException {
        this.checkStarted();
        EntryMessage entryMsg = new EntryMessage();
        entryMsg.setKey(key);
        entryMsg.setType(EntryMessage.MessageType.DELETE);
        return this.sendEntryMessage(entryMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mapMutex;
        synchronized (object) {
            return this.localMap != null ? this.localMap.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        Object object = this.mapMutex;
        synchronized (object) {
            if (this.localMap != null) {
                for (EntryValue<V> value : this.localMap.values()) {
                    result.add(value.getValue());
                }
            }
        }
        return result;
    }

    public Set<Member> members() {
        HashSet<Member> result = new HashSet<Member>();
        result.addAll(this.members.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOwner(K key) {
        EntryKey<K> stateKey = new EntryKey<K>(this.local, key);
        EntryValue<V> entryValue = null;
        Object object = this.mapMutex;
        synchronized (object) {
            entryValue = this.localMap != null ? this.localMap.get(stateKey) : null;
        }
        boolean result = false;
        if (entryValue != null) {
            result = entryValue.getOwner().getId().equals(this.local.getId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member getOwner(K key) {
        EntryKey<K> stateKey = new EntryKey<K>(this.local, key);
        EntryValue<V> entryValue = null;
        Object object = this.mapMutex;
        synchronized (object) {
            entryValue = this.localMap != null ? this.localMap.get(stateKey) : null;
        }
        return entryValue != null ? entryValue.getOwner() : null;
    }

    public boolean isCoordinator() {
        return this.local.equals(this.coordinator);
    }

    protected Member selectCordinator(Collection<Member> members) {
        Member result = this.local;
        for (Member member : members) {
            if (result.getId().compareTo(member.getId()) >= 0) continue;
            result = member;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V sendEntryMessage(EntryMessage entry) {
        Object result;
        block6: {
            result = null;
            MapRequest request = new MapRequest();
            String id = this.requestGenerator.generateId();
            Map<String, MapRequest> map = this.requests;
            synchronized (map) {
                this.requests.put(id, request);
            }
            try {
                ObjectMessage objMsg = this.session.createObjectMessage((Serializable)entry);
                objMsg.setJMSReplyTo((Destination)this.inboxTopic);
                objMsg.setJMSCorrelationID(id);
                this.producer.send((Destination)this.topic, (Message)objMsg);
                result = request.get(this.getHeartBeatInterval() * 2);
            }
            catch (JMSException e) {
                if (!this.started.get()) break block6;
                LOG.error((Object)("Failed to send EntryMessage " + entry), (Throwable)e);
            }
        }
        if (result instanceof IllegalAccessException) {
            throw (IllegalAccessException)result;
        }
        return (V)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponses(Message message) {
        block14: {
            if (message instanceof ObjectMessage) {
                ObjectMessage objMsg = (ObjectMessage)message;
                try {
                    Serializable payload = objMsg.getObject();
                    if (payload instanceof Member) {
                        this.handleHeartbeats((Member)payload);
                        break block14;
                    }
                    if (payload instanceof EntryMessage) {
                        EntryMessage entryMsg = (EntryMessage)payload;
                        EntryKey key = entryMsg.getKey();
                        EntryValue<Object> value = new EntryValue<Object>(key.getOwner(), entryMsg.getValue());
                        if (this.localMap == null) break block14;
                        boolean fireUpdate = false;
                        Object object = this.mapMutex;
                        synchronized (object) {
                            if (!this.localMap.containsKey(key)) {
                                this.localMap.put(key, value);
                                fireUpdate = true;
                            }
                        }
                        if (fireUpdate) {
                            this.fireMapChanged(key.getOwner(), key.getKey(), null, value.getValue());
                        }
                        break block14;
                    }
                    String id = objMsg.getJMSCorrelationID();
                    MapRequest result = null;
                    Map<String, MapRequest> map = this.requests;
                    synchronized (map) {
                        result = this.requests.remove(id);
                    }
                    if (result != null) {
                        result.put(objMsg.getObject());
                    }
                }
                catch (JMSException e) {
                    LOG.warn((Object)("Failed to process reply: " + message), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMapUpdates(Message message) {
        block27: {
            Throwable reply = null;
            if (message instanceof ObjectMessage) {
                block26: {
                    try {
                        ObjectMessage objMsg = (ObjectMessage)message;
                        EntryMessage entryMsg = (EntryMessage)objMsg.getObject();
                        EntryKey key = entryMsg.getKey();
                        EntryValue<Object> value = new EntryValue<Object>(key.getOwner(), entryMsg.getValue());
                        boolean containsKey = false;
                        boolean mapExists = false;
                        Object object = this.mapMutex;
                        synchronized (object) {
                            boolean bl = mapExists = this.localMap != null;
                            if (mapExists) {
                                containsKey = this.localMap.containsKey(key);
                            }
                        }
                        if (!mapExists) break block26;
                        if (containsKey) {
                            Member owner = this.getOwner(key.getKey());
                            if (owner.equals(key.getOwner()) && !key.isShare()) {
                                EntryValue<Object> old = null;
                                if (entryMsg.getType().equals((Object)EntryMessage.MessageType.INSERT)) {
                                    Object object2 = this.mapMutex;
                                    synchronized (object2) {
                                        old = this.localMap.put(key, value);
                                    }
                                }
                                Object object3 = this.mapMutex;
                                synchronized (object3) {
                                    old = this.localMap.remove(key);
                                }
                                this.fireMapChanged(owner, key.getKey(), old.getValue(), value.getValue());
                                break block26;
                            }
                            reply = new IllegalAccessException("Owned by " + owner);
                            break block26;
                        }
                        if (!entryMsg.getType().equals((Object)EntryMessage.MessageType.INSERT)) break block26;
                        object = this.mapMutex;
                        synchronized (object) {
                            this.localMap.put(key, value);
                        }
                        this.fireMapChanged(key.getOwner(), key.getKey(), null, value.getValue());
                    }
                    catch (JMSException e) {
                        LOG.warn((Object)"Failed to process map update", (Throwable)e);
                        reply = e;
                    }
                }
                try {
                    Destination replyTo = message.getJMSReplyTo();
                    String correlationId = message.getJMSCorrelationID();
                    ObjectMessage replyMsg = this.session.createObjectMessage((Serializable)((Object)reply));
                    replyMsg.setJMSCorrelationID(correlationId);
                    replyMsg.setJMSTimestamp(System.currentTimeMillis());
                    if (this.isCoordinator()) {
                        this.producer.send(replyTo, (Message)replyMsg);
                        break block27;
                    }
                    LRUSet<Message> lRUSet = this.mapUpdateReplies;
                    synchronized (lRUSet) {
                        this.mapUpdateReplies.add((Message)replyMsg);
                        break block27;
                    }
                }
                catch (JMSException e) {
                    if (this.started.get()) {
                        LOG.error((Object)"Failed to send response to a map update ", (Throwable)e);
                    }
                    break block27;
                }
            }
            LOG.warn((Object)("Unexpected map update message " + message));
        }
    }

    void handleHeartbeats(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objMsg = (ObjectMessage)message;
                Member member = (Member)objMsg.getObject();
                this.handleHeartbeats(member);
            } else {
                LOG.warn((Object)("Unexpected message: " + message));
            }
        }
        catch (JMSException e) {
            LOG.warn((Object)"Failed to handle heart beat", (Throwable)e);
        }
    }

    void handleHeartbeats(Member member) {
        member.setTimeStamp(System.currentTimeMillis());
        if (this.members.put(member.getId(), member) == null) {
            this.fireMemberStarted(member);
            if (!member.equals(this.local)) {
                this.sendHeartBeat(member.getInBoxDestination());
                if (this.isCoordinator()) {
                    this.updateNewMemberMap(member);
                }
            }
        }
    }

    void handleConsumerEvents(ConsumerEvent event) {
        Member member;
        if (!event.isStarted() && (member = this.members.remove(event.getConsumerId().toString())) != null) {
            this.fireMemberStopped(member);
            this.doElection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkMembership() {
        long checkTime;
        if (this.started.get()) {
            checkTime = System.currentTimeMillis() - (long)this.getHeartBeatInterval();
            boolean doElection = false;
            for (Member member : this.members.values()) {
                if (member.getTimeStamp() >= checkTime) continue;
                LOG.info((Object)("Member timestamp expired " + member));
                this.members.remove(member.getId());
                this.fireMemberStopped(member);
                doElection = true;
            }
            if (doElection) {
                this.doElection();
            }
        }
        checkTime = System.currentTimeMillis() - (long)(this.getHeartBeatInterval() * 2);
        ArrayList<Message> tmpList = new ArrayList<Message>();
        LRUSet<Message> lRUSet = this.mapUpdateReplies;
        synchronized (lRUSet) {
            try {
                for (Message msg : this.mapUpdateReplies) {
                    if (msg.getJMSTimestamp() >= checkTime) continue;
                    tmpList.add(msg);
                }
                for (Message msg : tmpList) {
                    this.mapUpdateReplies.remove(msg);
                }
            }
            catch (JMSException e) {
                LOG.warn((Object)"Failed to clear down mapUpdateReplies", (Throwable)e);
            }
        }
    }

    void sendHeartBeat() {
        this.sendHeartBeat((Destination)this.heartBeatTopic);
    }

    void sendHeartBeat(Destination destination) {
        block3: {
            if (this.started.get()) {
                try {
                    ObjectMessage msg = this.session.createObjectMessage((Serializable)this.local);
                    this.producer.send(destination, (Message)msg);
                }
                catch (Throwable e) {
                    if (!this.started.get()) break block3;
                    LOG.warn((Object)"Failed to send heart beat", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNewMemberMap(Member member) {
        block8: {
            ArrayList<Map.Entry<EntryKey<K>, EntryValue<V>>> list = new ArrayList<Map.Entry<EntryKey<K>, EntryValue<V>>>();
            Object object = this.mapMutex;
            synchronized (object) {
                if (this.localMap != null) {
                    for (Map.Entry<EntryKey<K>, EntryValue<V>> entry : this.localMap.entrySet()) {
                        list.add(entry);
                    }
                }
            }
            try {
                for (Map.Entry entry : list) {
                    EntryMessage entryMsg = new EntryMessage();
                    entryMsg.setKey((EntryKey)entry.getKey());
                    entryMsg.setValue(((EntryValue)entry.getValue()).getValue());
                    entryMsg.setType(EntryMessage.MessageType.INSERT);
                    ObjectMessage objMsg = this.session.createObjectMessage((Serializable)entryMsg);
                    if (member.equals(((EntryKey)entry.getKey()).getOwner())) continue;
                    this.producer.send(member.getInBoxDestination(), (Message)objMsg);
                }
            }
            catch (JMSException e) {
                if (!this.started.get()) break block8;
                LOG.warn((Object)"Failed to update new member ", (Throwable)e);
            }
        }
    }

    void fireMemberStarted(Member member) {
        LOG.info((Object)(this.local.getName() + " Member started " + member));
        for (MemberChangedListener l : this.membershipListeners) {
            l.memberStarted(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberStopped(Member member) {
        LOG.info((Object)(this.local.getName() + " Member stopped " + member));
        for (MemberChangedListener l : this.membershipListeners) {
            l.memberStopped(member);
        }
        ArrayList<EntryKey<K>> tmpList = new ArrayList<EntryKey<K>>();
        boolean mapExists = false;
        Object object = this.mapMutex;
        synchronized (object) {
            boolean bl = mapExists = this.localMap != null;
            if (mapExists) {
                for (EntryKey<K> entryKey : this.localMap.keySet()) {
                    if (!entryKey.getOwner().equals(member) || !entryKey.isRemoveOnExit()) continue;
                    tmpList.add(entryKey);
                }
            }
        }
        if (mapExists) {
            for (EntryKey entryKey : tmpList) {
                EntryValue<V> value = null;
                Object object2 = this.mapMutex;
                synchronized (object2) {
                    value = this.localMap.remove(entryKey);
                }
                this.fireMapChanged(member, entryKey.getKey(), value.getValue(), null);
            }
        }
    }

    void fireMapChanged(Member owner, Object key, Object oldValue, Object newValue) {
        for (MapChangedListener l : this.mapChangedListeners) {
            l.mapChanged(owner, key, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doElection() {
        block7: {
            this.coordinator = this.selectCordinator(this.members.values());
            if (this.isCoordinator() && this.started.get()) {
                ArrayList<Message> list = new ArrayList<Message>();
                LRUSet<Message> lRUSet = this.mapUpdateReplies;
                synchronized (lRUSet) {
                    list.addAll(this.mapUpdateReplies);
                    this.mapUpdateReplies.clear();
                }
                try {
                    for (Message msg : list) {
                        if (!this.started.get()) continue;
                        this.producer.send(msg.getJMSReplyTo(), msg);
                    }
                }
                catch (JMSException e) {
                    if (!this.started.get()) break block7;
                    LOG.error((Object)"Failed to resend replies", (Throwable)e);
                }
            }
        }
    }

    void checkStarted() throws IllegalStateException {
        if (!this.started.get()) {
            throw new IllegalStateException("GroupMap " + this.local.getName() + " not started");
        }
    }
}

