/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.openwire.tool.OpenWireGenerator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiSourceGenerator
extends OpenWireGenerator {
    protected Set<String> manuallyMaintainedClasses = new HashSet<String>();
    protected File destDir;
    protected File destFile;
    protected JClass jclass;
    protected JClass superclass;
    protected String simpleName;
    protected String className;
    protected String baseClass;
    protected StringBuffer buffer;

    public MultiSourceGenerator() {
        this.initialiseManuallyMaintainedClasses();
    }

    public Object run() {
        if (this.destDir == null) {
            throw new IllegalArgumentException("No destDir defined!");
        }
        System.out.println(this.getClass().getName() + " generating files in: " + this.destDir);
        this.destDir.mkdirs();
        this.buffer = new StringBuffer();
        JamClassIterator iter = this.getClasses();
        while (iter.hasNext()) {
            this.jclass = iter.nextClass();
            if (!this.isValidClass(this.jclass)) continue;
            this.processClass(this.jclass);
        }
        return null;
    }

    public List<JProperty> getProperties() {
        ArrayList<JProperty> answer = new ArrayList<JProperty>();
        JProperty[] properties = this.jclass.getDeclaredProperties();
        for (int i = 0; i < properties.length; ++i) {
            JProperty property = properties[i];
            if (!this.isValidProperty(property)) continue;
            answer.add(property);
        }
        return answer;
    }

    protected boolean isValidClass(JClass jclass) {
        if (jclass.getAnnotation("openwire:marshaller") == null) {
            return false;
        }
        return !this.manuallyMaintainedClasses.contains(jclass.getSimpleName());
    }

    protected void processClass(JClass jclass) {
        this.simpleName = jclass.getSimpleName();
        this.superclass = jclass.getSuperclass();
        System.out.println(this.getClass().getName() + " processing class: " + this.simpleName);
        this.className = this.getClassName(jclass);
        this.destFile = new File(this.destDir, this.className + this.filePostFix);
        this.baseClass = this.getBaseClassName(jclass);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.destFile));
            this.generateFile(out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Project project = new Project();
        project.init();
        FixCRLF fixCRLF = new FixCRLF();
        fixCRLF.setProject(project);
        fixCRLF.setSrcdir(this.destFile.getParentFile());
        fixCRLF.setIncludes(this.destFile.getName());
        fixCRLF.execute();
    }

    protected abstract void generateFile(PrintWriter var1) throws Exception;

    protected String getBaseClassName(JClass jclass) {
        String name;
        String answer = "BaseDataStructure";
        if (this.superclass != null && (name = this.superclass.getSimpleName()) != null && !name.equals("Object")) {
            answer = name;
        }
        return answer;
    }

    protected String getClassName(JClass jclass) {
        return jclass.getSimpleName();
    }

    public boolean isAbstractClass() {
        return this.jclass != null && this.jclass.isAbstract();
    }

    public String getAbstractClassText() {
        return this.isAbstractClass() ? "abstract " : "";
    }

    public boolean isMarshallerAware() {
        return this.isMarshallAware(this.jclass);
    }

    protected void initialiseManuallyMaintainedClasses() {
        String[] names = new String[]{"ActiveMQDestination", "ActiveMQTempDestination", "ActiveMQQueue", "ActiveMQTopic", "ActiveMQTempQueue", "ActiveMQTempTopic", "BaseCommand", "ActiveMQMessage", "ActiveMQTextMessage", "ActiveMQMapMessage", "ActiveMQBytesMessage", "ActiveMQStreamMessage", "ActiveMQBlobMessage", "DataStructureSupport", "WireFormatInfo", "ActiveMQObjectMessage"};
        for (int i = 0; i < names.length; ++i) {
            this.manuallyMaintainedClasses.add(names[i]);
        }
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String baseClass) {
        this.baseClass = baseClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public JClass getJclass() {
        return this.jclass;
    }

    public void setJclass(JClass jclass) {
        this.jclass = jclass;
    }

    public Set<String> getManuallyMaintainedClasses() {
        return this.manuallyMaintainedClasses;
    }

    public void setManuallyMaintainedClasses(Set<String> manuallyMaintainedClasses) {
        this.manuallyMaintainedClasses = manuallyMaintainedClasses;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public JClass getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(JClass superclass) {
        this.superclass = superclass;
    }
}

