/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.document.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicemix.document.DocumentRepository;
import org.apache.servicemix.document.Resource;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class DocumentRepositoryImpl
extends AbstractURLStreamHandlerService
implements DocumentRepository {
    public static final String PROTOCOL = "document";
    public static final String PROTOCOL_COLUMN = "document:";
    private volatile long index = 0L;
    private Map<Long, Resource> documents = new ConcurrentHashMap<Long, Resource>();

    public String register(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        out.close();
        return this.register(out.toByteArray());
    }

    public String register(final byte[] data) {
        return this.register(new Resource(){

            public InputStream open() throws IOException {
                return new ByteArrayInputStream(data);
            }
        });
    }

    public String register(Resource res) {
        long idx = ++this.index;
        this.documents.put(idx, res);
        return PROTOCOL_COLUMN + idx;
    }

    public void unregister(String url) {
        if (url.startsWith(PROTOCOL_COLUMN)) {
            String idx = url.substring(PROTOCOL_COLUMN.length());
            this.documents.remove(Long.parseLong(idx));
        }
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new URLConnection(url){

            public void connect() throws IOException {
            }

            public InputStream getInputStream() throws IOException {
                this.connect();
                Long idx = Long.parseLong(this.getURL().getPath());
                Resource res = (Resource)DocumentRepositoryImpl.this.documents.get(idx);
                if (res == null) {
                    throw new FileNotFoundException(this.getURL().toString());
                }
                return res.open();
            }
        };
    }
}

