/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisElementDataReader;
import org.apache.cxf.aegis.AegisElementDataWriter;
import org.apache.cxf.aegis.AegisReader;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.AegisXMLStreamDataReader;
import org.apache.cxf.aegis.AegisXMLStreamDataWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.DefaultTypeCreator;
import org.apache.cxf.aegis.type.DefaultTypeMapping;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.XMLTypeCreator;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.java5.Java5TypeCreator;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AegisContext {
    private boolean writeXsiTypes;
    private boolean readXsiTypes = true;
    private Set<String> rootClassNames;
    private Set<Class<?>> rootClasses;
    private Set<QName> rootTypeQNames;
    private TypeMapping typeMapping;
    private Set<Type> rootTypes;
    private Map<Class<?>, String> beanImplementationMap = new HashMap();
    private TypeCreationOptions configuration;
    private boolean mtomEnabled;
    private boolean mtomUseXmime;
    private String mappingNamespaceURI;

    public AegisContext() {
        this.rootClasses = new HashSet();
        this.rootTypeQNames = new HashSet<QName>();
    }

    public TypeCreator createTypeCreator() {
        AbstractTypeCreator xmlCreator = this.createRootTypeCreator();
        Java5TypeCreator j5Creator = new Java5TypeCreator();
        j5Creator.setNextCreator(this.createDefaultTypeCreator());
        j5Creator.setConfiguration(this.getTypeCreationOptions());
        xmlCreator.setNextCreator(j5Creator);
        return xmlCreator;
    }

    protected AbstractTypeCreator createRootTypeCreator() {
        XMLTypeCreator creator = new XMLTypeCreator();
        creator.setConfiguration(this.getTypeCreationOptions());
        return creator;
    }

    protected AbstractTypeCreator createDefaultTypeCreator() {
        DefaultTypeCreator creator = new DefaultTypeCreator();
        creator.setConfiguration(this.getTypeCreationOptions());
        return creator;
    }

    public void initialize() {
        if (this.configuration == null) {
            this.configuration = new TypeCreationOptions();
        }
        if (this.typeMapping == null) {
            boolean defaultNillable = this.configuration.isDefaultNillable();
            DefaultTypeMapping baseTM = DefaultTypeMapping.createDefaultTypeMapping(defaultNillable, this.mtomUseXmime);
            if (this.mappingNamespaceURI == null) {
                this.mappingNamespaceURI = "http://www.w3.org/2001/XMLSchema";
            }
            DefaultTypeMapping defaultTypeMapping = new DefaultTypeMapping(this.mappingNamespaceURI, baseTM);
            defaultTypeMapping.setTypeCreator(this.createTypeCreator());
            this.typeMapping = defaultTypeMapping;
        }
        this.processRootTypes();
    }

    public AegisReader<Element> createDomElementReader() {
        return new AegisElementDataReader(this);
    }

    public AegisReader<XMLStreamReader> createXMLStreamReader() {
        return new AegisXMLStreamDataReader(this);
    }

    public AegisWriter<Element> createDomElementWriter() {
        return new AegisElementDataWriter(this);
    }

    public AegisWriter<XMLStreamWriter> createXMLStreamWriter() {
        return new AegisXMLStreamDataWriter(this);
    }

    public Type getRootType(Class clazz) {
        if (this.rootClasses.contains(clazz)) {
            return this.typeMapping.getType(clazz);
        }
        return null;
    }

    public Type getRootType(QName schemaTypeName) {
        if (this.rootTypeQNames.contains(schemaTypeName)) {
            return this.typeMapping.getType(schemaTypeName);
        }
        return null;
    }

    private void processRootTypes() {
        this.rootTypes = new HashSet<Type>();
        if (this.rootClasses == null) {
            this.rootClasses = new HashSet();
        }
        this.rootTypeQNames = new HashSet<QName>();
        if (this.rootClassNames != null) {
            for (String string : this.rootClassNames) {
                Class<?> c = null;
                try {
                    c = ClassLoaderUtils.loadClass(string, TypeUtil.class);
                }
                catch (ClassNotFoundException e) {
                    throw new DatabindingException("Could not find override type class: " + string, (Throwable)e);
                }
                this.rootClasses.add(c);
            }
        }
        for (Class clazz : this.rootClasses) {
            Type t = this.typeMapping.getType(clazz);
            if (t == null) {
                t = this.typeMapping.getTypeCreator().createType(clazz);
                this.typeMapping.register(t);
            }
            this.rootTypeQNames.add(t.getSchemaType());
            if (!(t instanceof BeanType)) continue;
            BeanType bt = (BeanType)t;
            bt.getTypeInfo().setExtension(true);
            this.rootTypes.add(bt);
        }
    }

    public Set<String> getRootClassNames() {
        return this.rootClassNames;
    }

    public void setRootClassNames(Set<String> classNames) {
        this.rootClassNames = classNames;
    }

    public TypeCreationOptions getConfiguration() {
        return this.configuration;
    }

    public TypeCreationOptions getTypeCreationOptions() {
        return this.configuration;
    }

    public void setConfiguration(TypeCreationOptions newConfiguration) {
        this.configuration = newConfiguration;
    }

    public void setTypeCreationOptions(TypeCreationOptions newConfiguration) {
        this.configuration = newConfiguration;
    }

    public boolean isWriteXsiTypes() {
        return this.writeXsiTypes;
    }

    public boolean isReadXsiTypes() {
        return this.readXsiTypes;
    }

    public void setWriteXsiTypes(boolean flag) {
        this.writeXsiTypes = flag;
    }

    public void setReadXsiTypes(boolean flag) {
        this.readXsiTypes = flag;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Set<Type> getRootTypes() {
        return this.rootTypes;
    }

    public Map<Class<?>, String> getBeanImplementationMap() {
        return this.beanImplementationMap;
    }

    public void setBeanImplementationMap(Map<Class<?>, String> beanImplementationMap) {
        this.beanImplementationMap = beanImplementationMap;
    }

    public Set<Class<?>> getRootClasses() {
        return this.rootClasses;
    }

    public void setRootClasses(Set<Class<?>> rootClasses) {
        this.rootClasses = rootClasses;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomUseXmime() {
        return this.mtomUseXmime;
    }

    public void setMtomUseXmime(boolean mtomUseXmime) {
        this.mtomUseXmime = mtomUseXmime;
    }

    public String getMappingNamespaceURI() {
        return this.mappingNamespaceURI;
    }

    public void setMappingNamespaceURI(String mappingNamespaceURI) {
        this.mappingNamespaceURI = mappingNamespaceURI;
    }
}

