/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.OutputStream;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapOutInterceptor
extends AbstractSoapInterceptor {
    public static final String WROTE_ENVELOPE_START = "wrote.envelope.start";
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SoapOutInterceptor.class);
    private Bus bus;

    public SoapOutInterceptor(Bus b) {
        super("write");
        this.bus = b;
    }

    public SoapOutInterceptor(Bus b, String phase) {
        super(phase);
        this.bus = b;
    }

    @Override
    public void handleMessage(SoapMessage message) {
        if (!MessageUtils.isTrue(message.get(WROTE_ENVELOPE_START))) {
            this.writeSoapEnvelopeStart(message);
            OutputStream os = message.getContent(OutputStream.class);
            if (!(os instanceof WriteOnCloseOutputStream) && !MessageUtils.isDOMPresent(message)) {
                message.put(WROTE_ENVELOPE_START, (Object)Boolean.TRUE);
            }
        }
        message.getInterceptorChain().add(new SoapOutEndingInterceptor());
    }

    private void writeSoapEnvelopeStart(SoapMessage message) {
        SoapVersion soapVersion = message.getVersion();
        try {
            XMLStreamWriter xtw = message.getContent(XMLStreamWriter.class);
            xtw.setPrefix(soapVersion.getPrefix(), soapVersion.getNamespace());
            xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getEnvelope().getLocalPart(), soapVersion.getNamespace());
            xtw.writeNamespace(soapVersion.getPrefix(), soapVersion.getNamespace());
            boolean preexistingHeaders = message.hasHeaders();
            if (preexistingHeaders) {
                xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getHeader().getLocalPart(), soapVersion.getNamespace());
                List<Header> hdrList = message.getHeaders();
                for (Header header : hdrList) {
                    HeaderProcessor hp;
                    DataBinding b = header.getDataBinding();
                    if (b == null && (hp = this.bus.getExtension(HeaderManager.class).getHeaderProcessor(header.getName().getNamespaceURI())) != null) {
                        b = hp.getDataBinding();
                    }
                    if (b != null) {
                        b.createWriter(XMLStreamWriter.class).write(header.getObject(), xtw);
                        continue;
                    }
                    Element node = (Element)header.getObject();
                    StaxUtils.copy(node, xtw);
                }
            }
            boolean endedHeader = this.handleHeaderPart(preexistingHeaders, message);
            if (preexistingHeaders && !endedHeader) {
                xtw.writeEndElement();
            }
            xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getBody().getLocalPart(), soapVersion.getNamespace());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e, soapVersion.getSender());
        }
    }

    private boolean handleHeaderPart(boolean preexistingHeaders, SoapMessage message) {
        BindingMessageInfo wrappedBmi;
        boolean client;
        boolean endedHeader = false;
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class.getName());
        if (bop == null) {
            return endedHeader;
        }
        XMLStreamWriter xtw = message.getContent(XMLStreamWriter.class);
        boolean startedHeader = false;
        BindingOperationInfo unwrappedOp = bop;
        if (bop.isUnwrapped()) {
            unwrappedOp = bop.getWrappedOperation();
        }
        BindingMessageInfo bmi = (client = this.isRequestor(message)) ? unwrappedOp.getInput() : unwrappedOp.getOutput();
        BindingMessageInfo bindingMessageInfo = wrappedBmi = client ? bop.getInput() : bop.getOutput();
        if (bmi == null) {
            return endedHeader;
        }
        List<MessagePartInfo> parts = wrappedBmi.getMessageInfo().getMessageParts();
        if (parts.size() > 0) {
            MessageContentsList objs = MessageContentsList.getContentsList(message);
            if (objs == null) {
                return endedHeader;
            }
            SoapVersion soapVersion = message.getVersion();
            List<SoapHeaderInfo> headers = bmi.getExtensors(SoapHeaderInfo.class);
            if (headers == null) {
                return endedHeader;
            }
            for (SoapHeaderInfo header : headers) {
                MessagePartInfo part = header.getPart();
                if (part.getIndex() >= objs.size()) continue;
                Object arg = objs.get(part);
                objs.remove(part);
                if (!startedHeader && !preexistingHeaders) {
                    try {
                        xtw.writeStartElement(soapVersion.getPrefix(), soapVersion.getHeader().getLocalPart(), soapVersion.getNamespace());
                    }
                    catch (XMLStreamException e) {
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e, soapVersion.getSender());
                    }
                    startedHeader = true;
                }
                DataWriter<XMLStreamWriter> dataWriter = this.getDataWriter(message);
                dataWriter.write(arg, header.getPart(), xtw);
            }
            if (startedHeader || preexistingHeaders) {
                try {
                    xtw.writeEndElement();
                    endedHeader = true;
                }
                catch (XMLStreamException e) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e, soapVersion.getSender());
                }
            }
        }
        return endedHeader;
    }

    @Override
    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey("org.apache.cxf.client"));
    }

    protected DataWriter<XMLStreamWriter> getDataWriter(Message message) {
        Service service = ServiceModelUtil.getService(message.getExchange());
        DataWriter<XMLStreamWriter> dataWriter = service.getDataBinding().createWriter(XMLStreamWriter.class);
        dataWriter.setAttachments(message.getAttachments());
        if (dataWriter == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAWRITER", BUNDLE, service.getName()));
        }
        return dataWriter;
    }

    public class SoapOutEndingInterceptor
    extends AbstractSoapInterceptor {
        public SoapOutEndingInterceptor() {
            super(SoapOutEndingInterceptor.class.getName(), "write-ending");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            SoapVersion soapVersion = message.getVersion();
            try {
                XMLStreamWriter xtw = message.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndElement();
                    xtw.writeEndElement();
                    xtw.writeEndDocument();
                    xtw.flush();
                }
            }
            catch (XMLStreamException e) {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e, soapVersion.getSender());
            }
        }
    }
}

