/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.core.EntityTag;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTagHeaderProvider
implements RuntimeDelegate.HeaderDelegate<EntityTag> {
    private static final String WEAK_PREFIX = "W/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EntityTag fromString(String header) {
        String tag = null;
        boolean weak = false;
        int i = header.indexOf(WEAK_PREFIX);
        if (i != -1) {
            weak = true;
            if (i + 2 >= header.length()) return new EntityTag("", weak);
            tag = header.substring(i + 2);
        } else {
            tag = header;
        }
        if (tag.length() < 2 || !tag.startsWith("\"") || !tag.endsWith("\"")) {
            throw new IllegalArgumentException("Misformatted ETag : " + header);
        }
        tag = tag.length() == 2 ? "" : tag.substring(1, tag.length() - 1);
        return new EntityTag(tag, weak);
    }

    public String toString(EntityTag tag) {
        StringBuilder sb = new StringBuilder();
        if (tag.isWeak()) {
            sb.append(WEAK_PREFIX);
        }
        sb.append("\"").append(tag.getValue()).append("\"");
        return sb.toString();
    }
}

