/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder {
    private String scheme;
    private String userInfo;
    private int port;
    private String host;
    private List<PathSegment> paths;
    private MultivaluedMap<String, String> matrix;
    private String fragment;
    private MultivaluedMap<String, String> query;

    public UriBuilderImpl() {
    }

    public UriBuilderImpl(URI uri) {
        this.setUriParts(uri);
    }

    public URI build() throws UriBuilderException {
        try {
            return new URI(this.scheme, this.userInfo, this.host, this.port, this.buildPath(), this.buildQuery(), this.fragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    public URI build(Map<String, Object> parts) throws IllegalArgumentException, UriBuilderException {
        return null;
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return null;
    }

    public UriBuilder clone() {
        return new UriBuilderImpl(this.build());
    }

    public UriBuilder encode(boolean enable) {
        return this;
    }

    public UriBuilder fragment(String theFragment) throws IllegalArgumentException {
        this.fragment = theFragment;
        return this;
    }

    public UriBuilder host(String theHost) throws IllegalArgumentException {
        this.host = theHost;
        return this;
    }

    public UriBuilder matrixParam(String name, String value) throws IllegalArgumentException {
        this.matrix.putSingle((Object)name, (Object)value);
        return this;
    }

    public UriBuilder path(String ... segments) throws IllegalArgumentException {
        if (this.paths == null) {
            this.paths = new ArrayList<PathSegment>();
        }
        for (String segment : segments) {
            this.paths.add(new PathSegmentImpl(segment, false));
        }
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        return null;
    }

    public UriBuilder path(Method ... methods) throws IllegalArgumentException {
        return null;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        return null;
    }

    public UriBuilder port(int thePort) throws IllegalArgumentException {
        this.port = thePort;
        return this;
    }

    public UriBuilder queryParam(String name, String value) throws IllegalArgumentException {
        if (this.query == null) {
            this.query = new MetadataMap<String, String>();
        }
        this.query.add((Object)name, (Object)value);
        return this;
    }

    public UriBuilder replaceMatrixParams(String m) throws IllegalArgumentException {
        this.matrix = JAXRSUtils.getStructuredParams(m, ";", true);
        return this;
    }

    public UriBuilder replaceQueryParams(String q) throws IllegalArgumentException {
        this.query = JAXRSUtils.getStructuredParams(q, "&", true);
        return this;
    }

    public UriBuilder scheme(String s) throws IllegalArgumentException {
        this.scheme = s;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
        return this;
    }

    public UriBuilder userInfo(String ui) throws IllegalArgumentException {
        this.userInfo = ui;
        return this;
    }

    private void setUriParts(URI uri) {
        this.scheme = uri.getScheme();
        this.port = uri.getPort();
        this.host = uri.getHost();
        this.paths = JAXRSUtils.getPathSegments(uri.getPath(), false);
        this.fragment = uri.getFragment();
        this.query = JAXRSUtils.getStructuredParams(uri.getQuery(), "&", true);
        this.userInfo = uri.getUserInfo();
    }

    private String buildPath() {
        StringBuilder sb = new StringBuilder();
        for (PathSegment ps : this.paths) {
            String p = ps.getPath();
            if (!p.startsWith("/")) {
                sb.append('/');
            }
            sb.append(p);
        }
        return sb.toString();
    }

    private String buildQuery() {
        StringBuilder b = new StringBuilder();
        Iterator it = this.query.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            b.append((String)entry.getKey()).append('=').append((String)((List)entry.getValue()).get(0));
            if (!it.hasNext()) continue;
            b.append('&');
        }
        return b.length() > 0 ? b.toString() : null;
    }

    public boolean isEncode() {
        return false;
    }

    public UriBuilder replacePath(String ... segments) throws IllegalArgumentException {
        return null;
    }

    public UriBuilder extension(String arg0) {
        return null;
    }
}

