/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) {
        try {
            this.processResponse(message);
        }
        finally {
            ProviderFactory.getInstance().cleatThreadLocalProxies();
            ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get("root.resource.class");
            if (cri != null) {
                cri.clearThreadLocalProxies();
            }
        }
    }

    private void processResponse(Message message) {
        MessageContentsList objs = MessageContentsList.getContentsList(message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        if (objs.get(0) != null) {
            Object responseObj = objs.get(0);
            Response response = null;
            response = objs.get(0) instanceof Response ? (Response)responseObj : Response.ok(responseObj).build();
            Exchange exchange = message.getExchange();
            OperationResourceInfo operation = (OperationResourceInfo)exchange.get(OperationResourceInfo.class.getName());
            List<ProviderInfo<ResponseHandler>> handlers = ProviderFactory.getInstance().getResponseHandlers();
            for (ProviderInfo<ResponseHandler> rh : handlers) {
                Response r = rh.getProvider().handleResponse(message, operation, response);
                if (r == null) continue;
                response = r;
            }
            message.put(Message.RESPONSE_CODE, response.getStatus());
            message.put(Message.PROTOCOL_HEADERS, response.getMetadata());
            responseObj = response.getEntity();
            if (responseObj == null) {
                return;
            }
            Class<?> targetType = responseObj.getClass();
            List<MediaType> availableContentTypes = this.computeAvailableContentTypes(message, response);
            Method invoked = operation == null ? null : operation.getMethodToInvoke();
            MessageBodyWriter<?> writer = null;
            MediaType responseType = null;
            for (MediaType type : availableContentTypes) {
                writer = ProviderFactory.getInstance().createMessageBodyWriter(targetType, invoked != null ? invoked.getGenericReturnType() : null, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, type, exchange.getInMessage());
                if (writer == null) continue;
                responseType = type;
                break;
            }
            OutputStream out = message.getContent(OutputStream.class);
            if (writer == null) {
                message.put(Message.RESPONSE_CODE, 406);
                this.writeResponseErrorMessage(out, "NO_MSG_WRITER", invoked != null ? invoked.getReturnType().getSimpleName() : "");
                return;
            }
            try {
                responseType = this.checkFinalContentType(responseType);
                LOG.fine("Response content type is: " + responseType.toString());
                message.put("Content-Type", responseType.toString());
                LOG.fine("Response EntityProvider is: " + writer.getClass().getName());
                writer.writeTo(responseObj, targetType, invoked.getGenericReturnType(), invoked != null ? invoked.getAnnotations() : new Annotation[]{}, responseType, response.getMetadata(), out);
            }
            catch (IOException e) {
                e.printStackTrace();
                message.put(Message.RESPONSE_CODE, 500);
                this.writeResponseErrorMessage(out, "SERIALIZE_ERROR", responseObj.getClass().getSimpleName());
            }
        } else {
            message.put(Message.RESPONSE_CODE, 204);
        }
    }

    private void writeResponseErrorMessage(OutputStream out, String errorString, String parameter) {
        try {
            out.write(new org.apache.cxf.common.i18n.Message(errorString, BUNDLE, parameter).toString().getBytes("UTF-8"));
        }
        catch (IOException another) {
            // empty catch block
        }
    }

    private List<MediaType> computeAvailableContentTypes(Message message, Response response) {
        Object contentType = response.getMetadata().getFirst((Object)"Content-Type");
        Exchange exchange = message.getExchange();
        List<MediaType> produceTypes = null;
        OperationResourceInfo operation = exchange.get(OperationResourceInfo.class);
        produceTypes = contentType != null ? Collections.singletonList(MediaType.valueOf((String)contentType.toString())) : (operation != null ? operation.getProduceTypes() : Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE));
        List<MediaType> acceptContentTypes = (List<MediaType>)exchange.get("Accept");
        if (acceptContentTypes == null) {
            acceptContentTypes = JAXRSUtils.sortMediaTypes("*/*");
        }
        return JAXRSUtils.intersectMimeTypes(acceptContentTypes, produceTypes);
    }

    private MediaType checkFinalContentType(MediaType mt) {
        if (mt.isWildcardType() && mt.isWildcardSubtype()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return mt;
    }
}

