/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProduceMime(value={"application/json"})
@ConsumeMime(value={"application/json"})
@Provider
public final class JSONProvider
extends AbstractJAXBProvider {
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            Class<?> theType = this.getActualType(type, genericType);
            JAXBContext context = this.getJAXBContext(theType, genericType);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            MappedXMLInputFactory factory = new MappedXMLInputFactory(this.namespaceMap);
            XMLStreamReader xsw = factory.createXMLStreamReader(is);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) ? unmarshaller.unmarshal(xsw, theType) : unmarshaller.unmarshal(xsw);
            return response;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            Object actualObject = this.checkAdapter(obj, anns);
            Class<?> actualClass = actualObject.getClass();
            if (cls == genericType) {
                genericType = actualClass;
            }
            Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, m);
            MappedXMLOutputFactory factory = new MappedXMLOutputFactory(this.namespaceMap);
            XMLStreamWriter xsw = factory.createXMLStreamWriter(os);
            ms.marshal(actualObject, xsw);
            xsw.close();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

