/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.persistence.RMStoreException;

public final class PersistenceUtils {
    private static PersistenceUtils instance;
    private JAXBContext context;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    private PersistenceUtils() {
    }

    public static PersistenceUtils getInstance() {
        if (null == instance) {
            instance = new PersistenceUtils();
        }
        return instance;
    }

    public SequenceAcknowledgement deserialiseAcknowledgment(InputStream is) {
        Object obj = null;
        try {
            obj = this.getUnmarshaller().unmarshal(is);
            if (obj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)obj;
                obj = el.getValue();
            }
        }
        catch (JAXBException ex) {
            throw new RMStoreException(ex);
        }
        return (SequenceAcknowledgement)obj;
    }

    public InputStream serialiseAcknowledgment(SequenceAcknowledgement ack) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.getMarshaller().marshal((Object)ack, (OutputStream)bos);
        }
        catch (JAXBException ex) {
            throw new RMStoreException(ex);
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private JAXBContext getContext() throws JAXBException {
        if (null == this.context) {
            this.context = JAXBContext.newInstance((String)PackageUtils.getPackageName(SequenceAcknowledgement.class), (ClassLoader)this.getClass().getClassLoader());
        }
        return this.context;
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        if (null == this.unmarshaller) {
            this.unmarshaller = this.getContext().createUnmarshaller();
        }
        return this.unmarshaller;
    }

    private Marshaller getMarshaller() throws JAXBException {
        if (null == this.marshaller) {
            this.marshaller = this.getContext().createMarshaller();
        }
        return this.marshaller;
    }
}

