/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvalidInputException
extends WorkflowException {
    private List genericErrors = new ArrayList();
    private Map errors = new HashMap();

    public InvalidInputException() {
    }

    public InvalidInputException(Object o) {
        if (o instanceof InvalidInputException) {
            InvalidInputException iie = (InvalidInputException)o;
            this.errors = iie.errors;
            this.genericErrors = iie.genericErrors;
        } else if (o instanceof Map) {
            this.errors = (Map)o;
        } else if (o instanceof String[]) {
            String[] stringMap = (String[])o;
            int length = stringMap.length;
            String name = null;
            for (int i = 0; i < length; ++i) {
                if (i % 2 == 0) {
                    name = stringMap[i];
                    continue;
                }
                this.addError(name, stringMap[i]);
            }
        } else {
            this.addError(o.toString());
        }
    }

    public InvalidInputException(String error) {
        super(error);
        this.addError(error);
    }

    public InvalidInputException(String name, String error) {
        this.addError(name, error);
    }

    public Map getErrors() {
        return this.errors;
    }

    public List getGenericErrors() {
        return this.genericErrors;
    }

    public void addError(String error) {
        this.genericErrors.add(error);
    }

    public void addError(String name, String error) {
        this.errors.put(name, error);
    }

    public String toString() {
        return "[InvalidInputException: [Error map: [" + this.errors + "]] [Error list: [" + this.genericErrors + "]]";
    }
}

