/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.hibernate;

import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class HibernateStep
implements Step {
    Date dueDate;
    Date finishDate;
    Date startDate;
    HibernateWorkflowEntry entry;
    List previousSteps;
    String caller;
    String owner;
    String status;
    int actionId;
    int stepId;
    long id = -1L;

    public HibernateStep() {
    }

    public HibernateStep(HibernateStep step) {
        this.actionId = step.getActionId();
        this.caller = step.getCaller();
        this.finishDate = step.getFinishDate();
        this.dueDate = step.getDueDate();
        this.startDate = step.getStartDate();
        this.owner = step.getOwner();
        this.status = step.getStatus();
        this.stepId = step.getStepId();
        this.previousSteps = step.getPreviousSteps();
        this.entry = step.entry;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setEntry(HibernateWorkflowEntry entry) {
        this.entry = entry;
    }

    public HibernateWorkflowEntry getEntry() {
        return this.entry;
    }

    public long getEntryId() {
        return this.entry.getId();
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public long[] getPreviousStepIds() {
        if (this.previousSteps == null) {
            return new long[0];
        }
        long[] previousStepIds = new long[this.previousSteps.size()];
        int i = 0;
        Iterator iterator = this.previousSteps.iterator();
        while (iterator.hasNext()) {
            HibernateStep hibernateStep = (HibernateStep)iterator.next();
            previousStepIds[i] = hibernateStep.getId();
            ++i;
        }
        return previousStepIds;
    }

    public void setPreviousSteps(List previousSteps) {
        this.previousSteps = previousSteps;
    }

    public List getPreviousSteps() {
        return this.previousSteps;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStepId(int stepId) {
        this.stepId = stepId;
    }

    public int getStepId() {
        return this.stepId;
    }
}

