/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.memory;

import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.memory.SerializableWorkflowStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class SerializableCache
implements Serializable {
    private static transient SerializableCache instance;
    HashMap currentStepsCache;
    HashMap entryCache = new HashMap();
    HashMap historyStepsCache;
    HashMap propertySetCache;
    long globalEntryId = 1L;
    long globalStepId = 1L;

    private SerializableCache() {
        this.currentStepsCache = new HashMap();
        this.historyStepsCache = new HashMap();
        this.propertySetCache = new HashMap();
    }

    public List query(WorkflowQuery query) {
        return Collections.EMPTY_LIST;
    }

    static SerializableCache getInstance() {
        if (instance == null) {
            instance = SerializableCache.load();
        }
        return instance;
    }

    static SerializableCache load() {
        try {
            FileInputStream fis = new FileInputStream(new File(SerializableWorkflowStore.storeFile));
            ObjectInputStream ois = new ObjectInputStream(fis);
            SerializableCache o = (SerializableCache)ois.readObject();
            fis.close();
            return o;
        }
        catch (Exception e) {
            SerializableWorkflowStore.log.fatal((Object)("cannot store in file " + SerializableWorkflowStore.storeFile + ". Create a new blank store."));
            return new SerializableCache();
        }
    }

    static void store() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(SerializableWorkflowStore.storeFile));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(SerializableCache.getInstance());
            fos.close();
        }
        catch (Exception e) {
            SerializableWorkflowStore.log.fatal((Object)("cannot store in file " + SerializableWorkflowStore.storeFile + "."));
        }
    }
}

