/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AllowOwnerOfStepCondition
implements Condition {
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String stepIdString = (String)args.get("stepId");
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        if (stepIdString == null) {
            throw new WorkflowException("This condition expects a stepId!");
        }
        int stepId = 0;
        if (stepIdString != null) {
            try {
                stepId = Integer.parseInt(stepIdString);
            }
            catch (Exception ex) {
                throw new WorkflowException("This condition expects a stepId > 0!");
            }
        }
        WorkflowStore store = (WorkflowStore)transientVars.get("store");
        List historySteps = store.findHistorySteps(entry.getId());
        Iterator iterator = historySteps.iterator();
        while (iterator.hasNext()) {
            Step step = (Step)iterator.next();
            if (stepId != step.getStepId() || step.getOwner() == null || context.getCaller() == null || !context.getCaller().equals(step.getOwner())) continue;
            return true;
        }
        return false;
    }
}

