/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicemix.jbi.jaxp.ExtendedNamespaceContext;

public class SimpleNamespaceContext
implements ExtendedNamespaceContext {
    private SimpleNamespaceContext parent;
    private Map namespaces;

    public SimpleNamespaceContext() {
        this.namespaces = new HashMap();
    }

    public SimpleNamespaceContext(SimpleNamespaceContext parent, Map namespaces) {
        this.parent = parent;
        this.namespaces = namespaces;
    }

    public SimpleNamespaceContext getParent() {
        return this.parent;
    }

    public Iterator getPrefixes() {
        HashSet prefixes = new HashSet();
        SimpleNamespaceContext context = this;
        while (context != null) {
            prefixes.addAll(context.namespaces.keySet());
            context = context.parent;
        }
        return prefixes.iterator();
    }

    public String getNamespaceURI(String prefix) {
        String uri = (String)this.namespaces.get(prefix);
        if (uri == null && this.parent != null) {
            uri = this.parent.getNamespaceURI(prefix);
        }
        return uri;
    }

    public String getPrefix(String namespaceURI) {
        SimpleNamespaceContext context = this;
        while (context != null) {
            for (Map.Entry entry : context.namespaces.keySet()) {
                if (!entry.getValue().equals(namespaceURI)) continue;
                return (String)entry.getKey();
            }
            context = context.parent;
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        HashSet prefixes = new HashSet();
        SimpleNamespaceContext context = this;
        while (context != null) {
            for (Map.Entry entry : context.namespaces.keySet()) {
                if (!entry.getValue().equals(namespaceURI)) continue;
                prefixes.add(entry.getKey());
            }
            context = context.parent;
        }
        return prefixes.iterator();
    }

    public void add(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }
}

