/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging;

import java.util.LinkedList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EventAdminTracker
extends ServiceTracker
implements EventAdmin {
    private final LinkedList m_queue;
    private BundleContext m_context;
    private EventAdmin m_service;
    private int m_maxSize;

    public EventAdminTracker(BundleContext context) {
        super(context, EventAdmin.class.getName(), null);
        this.m_context = context;
        this.m_queue = new LinkedList();
        this.m_maxSize = 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(Event event) {
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            this.m_queue.add(event);
        }
        this.deliver();
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            this.m_queue.add(event);
        }
        this.deliver();
        this.cleanup();
    }

    public Object addingService(ServiceReference serviceReference) {
        this.m_service = (EventAdmin)this.m_context.getService(serviceReference);
        this.deliver();
        return this.m_service;
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.m_service = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver() {
        EventAdmin forDelivery = this.m_service;
        if (forDelivery == null) {
            return;
        }
        while (this.m_queue.size() > 0) {
            Event event = null;
            LinkedList linkedList = this.m_queue;
            synchronized (linkedList) {
                if (this.m_queue.size() > 0) {
                    event = (Event)this.m_queue.remove(0);
                }
            }
            if (event == null) continue;
            forDelivery.postEvent(event);
        }
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("MaxSize must not be a negative number: " + maxSize);
        }
        if (maxSize > 1000) {
            String message = "MaxSize must not be a larger than 1000 for memory constraint reasons: " + maxSize;
            throw new IllegalArgumentException(message);
        }
        this.m_maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        while (this.m_queue.size() > this.m_maxSize) {
            LinkedList linkedList = this.m_queue;
            synchronized (linkedList) {
                this.m_queue.remove(0);
            }
        }
    }
}

