/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.osgi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.management.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.DefaultServiceUnit;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.osgi.EndpointWrapper;
import org.apache.servicemix.id.IdGenerator;

public class EndpointTracker {
    private static final Log LOGGER = LogFactory.getLog(EndpointTracker.class);
    protected DefaultComponent component;
    protected Map<EndpointWrapper, OsgiServiceUnit> endpoints = new ConcurrentHashMap<EndpointWrapper, OsgiServiceUnit>();

    public DefaultComponent getComponent() {
        return this.component;
    }

    public void setComponent(DefaultComponent component) {
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(EndpointWrapper wrapper, Map properties) throws Exception {
        Endpoint endpoint;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[" + this.component.getComponentName() + "] Endpoint registered with properties: " + properties));
        }
        if (this.component.isKnownEndpoint(endpoint = wrapper.getEndpoint())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[" + this.component.getComponentName() + "] Endpoint recognized"));
            }
            OsgiServiceUnit su = new OsgiServiceUnit(this.component, endpoint, wrapper.getClassLoader());
            this.endpoints.put(wrapper, su);
            this.component.getRegistry().registerServiceUnit(su);
            if (this.component.isStarted()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(su.getConfigurationClassLoader());
                    su.start();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(EndpointWrapper wrapper, Map properties) throws Exception {
        OsgiServiceUnit su;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[" + this.component.getComponentName() + "] Endpoint unregistered with properties: " + properties));
        }
        if ((su = this.endpoints.remove(wrapper)) != null && this.component.isKnownEndpoint(su.getEndpoint())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[" + this.component.getComponentName() + "] Endpoint recognized"));
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(su.getConfigurationClassLoader());
                    su.stop();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            finally {
                this.component.getRegistry().unregisterServiceUnit(su);
            }
        }
    }

    public static class OsgiServiceUnit
    extends DefaultServiceUnit {
        private static final IdGenerator idGenerator = new IdGenerator();
        private final Endpoint endpoint;
        private final ClassLoader classLoader;

        public OsgiServiceUnit(DefaultComponent component, Endpoint endpoint, ClassLoader classLoader) throws DeploymentException {
            this.component = component;
            this.name = idGenerator.generateSanitizedId();
            this.endpoint = endpoint;
            this.classLoader = classLoader;
            this.endpoint.setServiceUnit(this);
            this.endpoint.validate();
            this.addEndpoint(this.endpoint);
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public ClassLoader getConfigurationClassLoader() {
            if (this.classLoader != null) {
                return this.classLoader;
            }
            return super.getConfigurationClassLoader();
        }
    }
}

