/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.jca;

import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.RobustInOnly;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;

public class JcaProviderProcessor
extends AbstractJmsProcessor {
    protected Destination destination;
    protected Destination replyToDestination;
    protected DeliveryChannel channel;
    protected ConnectionFactory connectionFactory;

    public JcaProviderProcessor(JmsEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    public void start() throws Exception {
        InitialContext ctx = this.getInitialContext();
        this.connectionFactory = this.getConnectionFactory(ctx);
        this.channel = this.endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() == null) {
                throw new IllegalStateException("No destination provided");
            }
        }
    }

    public void stop() throws Exception {
        this.destination = null;
        this.replyToDestination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            exchange.setError((Exception)new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            this.channel.send(exchange);
            return;
        }
        Connection connection = null;
        Session session = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            if (this.destination == null) {
                this.destination = "queue".equals(this.endpoint.getDestinationStyle()) ? session.createQueue(this.endpoint.getJmsProviderDestinationName()) : session.createTopic(this.endpoint.getJmsProviderDestinationName());
            }
            MessageProducer producer = session.createProducer(this.destination);
            Message msg = this.createMessageFromExchange(session, exchange);
            producer.send(msg);
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        exchange.setStatus(ExchangeStatus.DONE);
        this.channel.send(exchange);
    }
}

