/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class MainRunner
implements InitializingBean,
Runnable {
    private static final Log LOG = LogFactory.getLog(MainRunner.class);
    private Class main;
    private String[] args = new String[0];
    private boolean asyncRun = true;
    private long delay;

    public String toString() {
        return "MainRunner(" + ObjectHelper.name((Class)this.main) + " " + Arrays.asList(this.getArgs()) + ")";
    }

    public void run() {
        try {
            this.runMethodWithoutCatchingExceptions();
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Class: " + ObjectHelper.name((Class)this.main) + " does not have a main method: " + e), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Failed to run: " + this + ". Reason: " + e), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            LOG.error((Object)("Failed to run: " + this + ". Reason: " + throwable), throwable);
        }
    }

    public void runMethodWithoutCatchingExceptions() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Caught: " + e), (Throwable)e);
            }
        }
        if (!Modifier.isStatic((method = this.main.getMethod("main", String[].class)).getModifiers())) {
            throw new IllegalArgumentException("The main method is not static!: " + method);
        }
        Object[] arguments = new Object[]{this.getArgs()};
        method.invoke(null, arguments);
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public boolean isAsyncRun() {
        return this.asyncRun;
    }

    public void setAsyncRun(boolean asyncRun) {
        this.asyncRun = asyncRun;
    }

    public Class getMain() {
        return this.main;
    }

    public void setMain(Class main) {
        this.main = main;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.main == null) {
            throw new IllegalArgumentException("You must specify a main class!");
        }
        if (this.isAsyncRun()) {
            Thread thread = new Thread((Runnable)this, "Thread for: " + this);
            thread.start();
        } else {
            this.runMethodWithoutCatchingExceptions();
        }
    }
}

