/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.jms.endpoints.AbstractJmsMarshaler;
import org.apache.servicemix.jms.endpoints.JmsConsumerMarshaler;
import org.apache.servicemix.soap.api.Interceptor;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.core.MessageImpl;
import org.apache.servicemix.soap.core.PhaseInterceptorChain;
import org.apache.servicemix.soap.interceptors.mime.AttachmentsInInterceptor;
import org.apache.servicemix.soap.interceptors.mime.AttachmentsOutInterceptor;
import org.apache.servicemix.soap.interceptors.xml.BodyOutInterceptor;
import org.apache.servicemix.soap.interceptors.xml.StaxInInterceptor;
import org.apache.servicemix.soap.interceptors.xml.StaxOutInterceptor;
import org.apache.servicemix.soap.util.stax.StaxSource;

public class DefaultConsumerMarshaler
extends AbstractJmsMarshaler
implements JmsConsumerMarshaler {
    private URI mep;

    public DefaultConsumerMarshaler() {
        this.mep = JbiConstants.IN_ONLY;
    }

    public DefaultConsumerMarshaler(URI mep) {
        this.mep = mep;
    }

    public URI getMep() {
        return this.mep;
    }

    public void setMep(URI mep) {
        this.mep = mep;
    }

    public JmsConsumerMarshaler.JmsContext createContext(javax.jms.Message message) throws Exception {
        return new Context(message);
    }

    public MessageExchange createExchange(JmsConsumerMarshaler.JmsContext jmsContext, ComponentContext jbiContext) throws Exception {
        Context ctx = (Context)jmsContext;
        MessageExchange exchange = jbiContext.getDeliveryChannel().createExchangeFactory().createExchange(this.mep);
        NormalizedMessage inMessage = exchange.createMessage();
        this.populateMessage(ctx.message, inMessage);
        if (this.isCopyProperties()) {
            this.copyPropertiesFromJMS(ctx.message, inMessage);
        }
        exchange.setMessage(inMessage, "in");
        return exchange;
    }

    public javax.jms.Message createOut(MessageExchange exchange, NormalizedMessage outMsg, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add((Interceptor)new AttachmentsOutInterceptor());
        chain.add((Interceptor)new StaxOutInterceptor());
        chain.add((Interceptor)new BodyOutInterceptor());
        MessageImpl msg = new MessageImpl();
        msg.setContent(Source.class, (Object)outMsg.getContent());
        msg.setContent(OutputStream.class, (Object)baos);
        for (String attId : outMsg.getAttachmentNames()) {
            msg.getAttachments().put(attId, outMsg.getAttachment(attId));
        }
        chain.doIntercept((Message)msg);
        TextMessage text = session.createTextMessage(baos.toString());
        if (msg.get((Object)"Content-Type") != null) {
            text.setStringProperty("ContentType", (String)msg.get((Object)"Content-Type"));
        }
        if (this.isCopyProperties()) {
            this.copyPropertiesFromNM(outMsg, (javax.jms.Message)text);
        }
        return text;
    }

    public javax.jms.Message createFault(MessageExchange exchange, Fault fault, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add((Interceptor)new AttachmentsOutInterceptor());
        chain.add((Interceptor)new StaxOutInterceptor());
        chain.add((Interceptor)new BodyOutInterceptor());
        MessageImpl msg = new MessageImpl();
        msg.setContent(Source.class, (Object)fault.getContent());
        msg.setContent(OutputStream.class, (Object)baos);
        for (String attId : fault.getAttachmentNames()) {
            msg.getAttachments().put(attId, fault.getAttachment(attId));
        }
        chain.doIntercept((Message)msg);
        TextMessage text = session.createTextMessage(baos.toString());
        if (msg.get((Object)"Content-Type") != null) {
            text.setStringProperty("ContentType", (String)msg.get((Object)"Content-Type"));
        }
        text.setBooleanProperty("JBIFault", true);
        if (this.isCopyProperties()) {
            this.copyPropertiesFromNM((NormalizedMessage)fault, (javax.jms.Message)text);
        }
        return text;
    }

    public javax.jms.Message createError(MessageExchange exchange, Exception error, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        ObjectMessage message = session.createObjectMessage((Serializable)error);
        message.setBooleanProperty("JBIError", true);
        return message;
    }

    protected void populateMessage(javax.jms.Message message, NormalizedMessage normalizedMessage) throws Exception {
        if (message instanceof TextMessage) {
            PhaseInterceptorChain chain = new PhaseInterceptorChain();
            chain.add((Interceptor)new AttachmentsInInterceptor());
            chain.add((Interceptor)new StaxInInterceptor());
            MessageImpl msg = new MessageImpl();
            msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(((TextMessage)message).getText().getBytes()));
            if (message.propertyExists("ContentType")) {
                msg.put((Object)"Content-Type", (Object)message.getStringProperty("ContentType"));
            }
            chain.doIntercept((Message)msg);
            XMLStreamReader xmlReader = (XMLStreamReader)msg.getContent(XMLStreamReader.class);
            normalizedMessage.setContent((Source)new StaxSource(xmlReader));
            for (Map.Entry attachment : msg.getAttachments().entrySet()) {
                normalizedMessage.addAttachment((String)attachment.getKey(), (DataHandler)attachment.getValue());
            }
        } else {
            throw new UnsupportedOperationException("JMS message is not a TextMessage");
        }
    }

    protected static class Context
    implements JmsConsumerMarshaler.JmsContext,
    Serializable {
        javax.jms.Message message;

        Context(javax.jms.Message message) {
            this.message = message;
        }

        public javax.jms.Message getMessage() {
            return this.message;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.message);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.message = (javax.jms.Message)in.readObject();
        }
    }
}

