/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.multiplexing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.Context;

public class MultiplexingConsumerProcessor
extends AbstractJmsProcessor
implements MessageListener {
    protected Session session;
    protected Destination destination;
    protected MessageConsumer consumer;
    protected Map pendingMessages;

    public MultiplexingConsumerProcessor(JmsEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    protected void doInit(InitialContext ctx) throws Exception {
        this.session = this.connection.createSession(false, 1);
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() != null) {
                this.destination = "queue".equals(this.endpoint.getDestinationStyle()) ? this.session.createQueue(this.endpoint.getJmsProviderDestinationName()) : this.session.createTopic(this.endpoint.getJmsProviderDestinationName());
            } else {
                throw new IllegalStateException("No destination provided");
            }
        }
        this.pendingMessages = new ConcurrentHashMap();
        this.consumer = this.session.createConsumer(this.destination);
    }

    protected void doStart() throws Exception {
        this.consumer.setMessageListener((MessageListener)this);
    }

    protected void doStop() throws Exception {
        this.consumer.setMessageListener(null);
    }

    protected void doShutdown() throws Exception {
        this.session = null;
        this.destination = null;
        this.consumer = null;
        this.pendingMessages.clear();
        this.pendingMessages = null;
    }

    public void onMessage(final Message message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received jms message " + message));
        }
        this.endpoint.getServiceUnit().getComponent().getExecutor().execute(new Runnable(){

            public void run() {
                try {
                    if (MultiplexingConsumerProcessor.this.log.isDebugEnabled()) {
                        MultiplexingConsumerProcessor.this.log.debug((Object)("Handling jms message " + message));
                    }
                    Context context = MultiplexingConsumerProcessor.this.createContext();
                    MessageExchange exchange = MultiplexingConsumerProcessor.this.toNMS(message, context);
                    MultiplexingConsumerProcessor.this.pendingMessages.put(exchange.getExchangeId(), context);
                    MultiplexingConsumerProcessor.this.channel.send(exchange);
                }
                catch (Throwable e) {
                    MultiplexingConsumerProcessor.this.log.error((Object)"Error while handling jms message", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        Context context = (Context)this.pendingMessages.remove(exchange.getExchangeId());
        if (exchange instanceof InOnly && exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        Message message = (Message)context.getProperty(Message.class.getName());
        MessageProducer producer = null;
        Message response = null;
        try {
            response = this.fromNMSResponse(exchange, context, this.session);
            if (response != null) {
                producer = this.session.createProducer(message.getJMSReplyTo());
                if (this.endpoint.isUseMsgIdInResponse()) {
                    response.setJMSCorrelationID(message.getJMSMessageID());
                } else {
                    response.setJMSCorrelationID(message.getJMSCorrelationID());
                }
                producer.send(response);
            }
        }
        finally {
            if (producer != null) {
                producer.close();
            }
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
            }
        }
    }
}

