/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geronimo.gshell.CommandLine;
import org.apache.geronimo.gshell.CommandLineBuilder;
import org.apache.geronimo.gshell.DefaultVariables;
import org.apache.geronimo.gshell.ErrorNotification;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.command.CommandInfo;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.common.Arguments;
import org.apache.geronimo.gshell.common.StopWatch;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.layout.NotFoundException;
import org.apache.geronimo.gshell.layout.model.AliasNode;
import org.apache.geronimo.gshell.layout.model.CommandNode;
import org.apache.geronimo.gshell.layout.model.Node;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.registry.NotRegisteredException;
import org.apache.geronimo.gshell.shell.Environment;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=CommandExecutor.class, hint="default")
public class DefaultCommandExecutor
implements CommandExecutor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private LayoutManager layoutManager;
    @Requirement
    private CommandRegistry commandRegistry;
    @Requirement
    private CommandLineBuilder commandLineBuilder;
    @Requirement
    private Environment env;

    public DefaultCommandExecutor() {
    }

    public DefaultCommandExecutor(LayoutManager layoutManager, CommandRegistry commandRegistry, CommandLineBuilder commandLineBuilder, Environment env) {
        this.layoutManager = layoutManager;
        this.commandRegistry = commandRegistry;
        this.commandLineBuilder = commandLineBuilder;
        this.env = env;
    }

    public Object execute(String line) throws Exception {
        assert (line != null);
        this.log.info("Executing (String): {}", (Object)line);
        try {
            CommandLine cl = this.commandLineBuilder.create(line);
            return cl.execute();
        }
        catch (ErrorNotification n) {
            Throwable cause = n.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw n;
        }
    }

    public Object execute(Object ... args) throws Exception {
        assert (args != null);
        assert (args.length > 1);
        this.log.info("Executing (Object...): [{}]", (Object)Arguments.asString(args));
        return this.execute(String.valueOf(args[0]), Arguments.shift(args), this.env.getIO());
    }

    public Object execute(String path, Object[] args) throws Exception {
        assert (path != null);
        assert (args != null);
        this.log.info("Executing ({}): [{}]", (Object)path, (Object)Arguments.asString(args));
        return this.execute(path, args, this.env.getIO());
    }

    public Object execute(final Object[][] commands) throws Exception {
        int i;
        assert (commands != null);
        final IO[] ios = new IO[commands.length];
        PipedOutputStream pos = null;
        for (int i2 = 0; i2 < ios.length; ++i2) {
            OutputStream os;
            InputStream is;
            InputStream inputStream = is = i2 == 0 ? this.env.getIO().inputStream : new PipedInputStream(pos);
            if (i2 == ios.length - 1) {
                os = this.env.getIO().outputStream;
            } else {
                pos = new PipedOutputStream();
                os = pos;
            }
            ios[i2] = new IO(is, os, this.env.getIO().errorStream);
        }
        Thread[] threads = new Thread[commands.length];
        final CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        final AtomicReference ref = new AtomicReference();
        for (i = 0; i < commands.length; ++i) {
            final int idx = i;
            threads[i] = this.createThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Object o = DefaultCommandExecutor.this.execute(String.valueOf(commands[idx][0]), Arguments.shift(commands[idx]), ios[idx]);
                        if (idx == commands.length - 1) {
                            ref.set(o);
                        }
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                    finally {
                        if (idx > 0) {
                            IOUtil.close(ios[idx].inputStream);
                        }
                        if (idx < commands.length - 1) {
                            IOUtil.close(ios[idx].outputStream);
                        }
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < commands.length; ++i) {
            threads[i].join();
        }
        if (!errors.isEmpty()) {
            Throwable t = (Throwable)errors.get(0);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        return ref.get();
    }

    protected Thread createThread(Runnable run) {
        return new Thread(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(String path, Object[] args, final IO io) throws Exception {
        Object result;
        Command command;
        String searchPath = (String)this.env.getVariables().get("path");
        final Node node = this.layoutManager.findNode(path, searchPath);
        final String id = this.findCommandId(node);
        try {
            command = this.commandRegistry.lookup(id);
        }
        catch (NotRegisteredException e) {
            throw new NotFoundException(e.getMessage());
        }
        CommandContext context = new CommandContext(){
            final Variables vars;
            CommandInfo info;
            {
                this.vars = new DefaultVariables(DefaultCommandExecutor.this.env.getVariables());
            }

            public IO getIO() {
                return io;
            }

            public Variables getVariables() {
                return this.vars;
            }

            public CommandInfo getInfo() {
                if (this.info == null) {
                    this.info = new CommandInfo(){

                        public String getId() {
                            return id;
                        }

                        public String getName() {
                            if (node instanceof AliasNode) {
                                return ((AliasNode)node).getCommand();
                            }
                            return node.getName();
                        }

                        public String getAlias() {
                            if (node instanceof AliasNode) {
                                return node.getName();
                            }
                            return null;
                        }

                        public String getPath() {
                            return null;
                        }
                    };
                }
                return this.info;
            }
        };
        StopWatch watch = new StopWatch(true);
        try {
            result = command.execute(context, args);
            this.log.debug("Command completed with result: {}, after: {}", result, (Object)watch);
        }
        finally {
            try {
                this.env.getIO().flush();
            }
            catch (Exception ignore) {}
        }
        return result;
    }

    protected String findCommandId(Node node) throws NotFoundException {
        assert (node != null);
        if (node instanceof AliasNode) {
            AliasNode aliasNode = (AliasNode)node;
            String targetPath = aliasNode.getCommand();
            Node target = this.layoutManager.findNode(this.layoutManager.getLayout(), targetPath);
            return this.findCommandId(target);
        }
        if (node instanceof CommandNode) {
            CommandNode commandNode = (CommandNode)node;
            return commandNode.getId();
        }
        throw new NotFoundException("Unable to get command id for: " + node);
    }
}

