/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import org.apache.geronimo.gshell.DefaultEnvironment;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.common.StopWatch;
import org.apache.geronimo.gshell.lookup.EnvironmentLookup;
import org.apache.geronimo.gshell.lookup.IOLookup;
import org.apache.geronimo.gshell.plugin.CommandDiscoverer;
import org.apache.geronimo.gshell.plugin.CommandDiscoveryListener;
import org.apache.geronimo.gshell.security.ShellSecurityManager;
import org.apache.geronimo.gshell.shell.Environment;
import org.apache.geronimo.gshell.shell.InteractiveShell;
import org.apache.geronimo.gshell.shell.ShellInfo;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GShell
implements InteractiveShell {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassWorld classWorld;
    private final IO io;
    private final DefaultPlexusContainer container;
    private final SecurityManager sm;
    private final InteractiveShell shell;

    public GShell(IO io) throws Exception {
        this(new ClassWorld("gshell", Thread.currentThread().getContextClassLoader()), io);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GShell(ClassWorld classWorld, IO io) throws Exception {
        assert (classWorld != null);
        assert (io != null);
        this.classWorld = classWorld;
        this.io = io;
        StopWatch watch = new StopWatch(true);
        this.log.debug("Initializing");
        this.sm = new ShellSecurityManager();
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager(this.sm);
        try {
            DefaultContainerConfiguration config = new DefaultContainerConfiguration();
            config.setName("gshell");
            config.setClassWorld(classWorld);
            config.addComponentDiscoverer((ComponentDiscoverer)new CommandDiscoverer());
            config.addComponentDiscoveryListener((ComponentDiscoveryListener)new CommandDiscoveryListener());
            this.container = new DefaultPlexusContainer((ContainerConfiguration)config);
            IOLookup.set((PlexusContainer)this.container, io);
            DefaultEnvironment env = new DefaultEnvironment(io);
            EnvironmentLookup.set((PlexusContainer)this.container, env);
            this.shell = (InteractiveShell)this.container.lookup(InteractiveShell.class);
        }
        finally {
            System.setSecurityManager(psm);
        }
        this.log.debug("Initialized in {}", (Object)watch);
    }

    public ShellInfo getShellInfo() {
        return this.shell.getShellInfo();
    }

    public Environment getEnvironment() {
        return this.shell.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String line) throws Exception {
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager(this.sm);
        try {
            Object object = this.shell.execute(line);
            return object;
        }
        finally {
            System.setSecurityManager(psm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object ... args) throws Exception {
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager(this.sm);
        try {
            Object object = this.shell.execute(args);
            return object;
        }
        finally {
            System.setSecurityManager(psm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String path, Object[] args) throws Exception {
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager(this.sm);
        try {
            Object object = this.shell.execute(path, args);
            return object;
        }
        finally {
            System.setSecurityManager(psm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object[][] commands) throws Exception {
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager(this.sm);
        try {
            Object object = this.shell.execute(commands);
            return object;
        }
        finally {
            System.setSecurityManager(psm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object ... args) throws Exception {
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager(this.sm);
        try {
            this.shell.run(args);
        }
        finally {
            System.setSecurityManager(psm);
        }
    }
}

