/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.ansi;

import org.apache.geronimo.gshell.ansi.Buffer;
import org.apache.geronimo.gshell.ansi.Code;

public class Renderer {
    public static final String BEGIN_TOKEN = "@|";
    private static final int BEGIN_TOKEN_SIZE = "@|".length();
    public static final String END_TOKEN = "|";
    private static final int END_TOKEN_SIZE = "|".length();
    public static final String CODE_TEXT_SEPARATOR = " ";
    public static final String CODE_LIST_SEPARATOR = ",";
    private final Buffer buff = new Buffer();

    public String render(String input) throws RenderException {
        int p;
        assert (input != null);
        int c = 0;
        while (c < input.length() && (p = input.indexOf(BEGIN_TOKEN, c)) >= 0) {
            int s = input.indexOf(END_TOKEN, p + BEGIN_TOKEN_SIZE);
            if (s < 0) {
                throw new RenderException("Missing '|': " + input);
            }
            String expr = input.substring(p + BEGIN_TOKEN_SIZE, s);
            this.buff.append(input.substring(c, p));
            this.evaluate(expr);
            c = s + END_TOKEN_SIZE;
        }
        this.buff.append(input.substring(c));
        return this.buff.toString();
    }

    private void evaluate(String input) throws RenderException {
        assert (input != null);
        int i = input.indexOf(CODE_TEXT_SEPARATOR);
        if (i < 0) {
            throw new RenderException("Missing ANSI code/text separator ' ': " + input);
        }
        String tmp = input.substring(0, i);
        String[] codes = tmp.split(CODE_LIST_SEPARATOR);
        String text = input.substring(i + 1, input.length());
        for (String name : codes) {
            int code = Code.forName(name);
            this.buff.attrib(code);
        }
        this.buff.append(text);
        this.buff.attrib(0);
    }

    public static boolean test(String text) {
        return text != null && text.indexOf(BEGIN_TOKEN) >= 0;
    }

    public static String encode(String text, int code) {
        return new StringBuffer(BEGIN_TOKEN).append(Code.name(code)).append(CODE_TEXT_SEPARATOR).append(text).append(END_TOKEN).toString();
    }

    public static class RenderException
    extends RuntimeException {
        public RenderException(String msg) {
            super(msg);
        }
    }
}

