/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.branding;

import java.io.File;
import org.apache.geronimo.gshell.branding.Branding;
import org.codehaus.plexus.util.StringUtils;

public abstract class BrandingSupport
implements Branding {
    public String getDisplayName() {
        return StringUtils.capitalise(this.getName());
    }

    public String getProgramName() {
        return System.getProperty("program.name", this.getName());
    }

    public File getUserDirectory() {
        File userHome = new File(System.getProperty("user.home"));
        File dir = new File(userHome, "." + this.getName());
        return dir.getAbsoluteFile();
    }

    public File getSharedDirectory() {
        File dir = new File("/etc");
        return dir.getAbsoluteFile();
    }

    public String getProfileScriptName() {
        return this.getName() + ".profile";
    }

    public String getInteractiveScriptName() {
        return this.getName() + ".rc";
    }

    public String getHistoryFileName() {
        return this.getName() + ".history";
    }

    public String getPropertyName(String name) {
        assert (name != null);
        return this.getName() + "." + name;
    }

    public String getProperty(String name) {
        return System.getProperty(this.getPropertyName(name));
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

