/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import org.apache.geronimo.gshell.ansi.RenderWriter;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.helpers.MessageFormatter;

public class IO {
    public final InputStream inputStream;
    public final OutputStream outputStream;
    public final OutputStream errorStream;
    public final Reader in;
    public final PrintWriter out;
    public final PrintWriter err;
    private Verbosity verbosity = Verbosity.INFO;

    public IO(InputStream in, OutputStream out, OutputStream err, boolean autoFlush) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        this.inputStream = in;
        this.outputStream = out;
        this.errorStream = err;
        this.in = new InputStreamReader(in);
        this.out = new RenderWriter(this.outputStream, autoFlush);
        this.err = this.isSharedOutputStreams() ? this.out : new RenderWriter(this.errorStream, autoFlush);
    }

    public IO(InputStream in, OutputStream out, OutputStream err) {
        this(in, out, err, true);
    }

    public IO(InputStream in, OutputStream out, boolean autoFlush) {
        this(in, out, out, autoFlush);
    }

    public IO(InputStream in, OutputStream out) {
        this(in, out, out);
    }

    public IO() {
        this(System.in, (OutputStream)System.out, System.err);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public boolean isSharedOutputStreams() {
        return this.outputStream == this.errorStream;
    }

    public void setVerbosity(Verbosity verbosity) {
        assert (verbosity != null);
        this.verbosity = verbosity;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public boolean isQuiet() {
        return this.verbosity == Verbosity.QUIET;
    }

    public boolean isInfo() {
        return this.verbosity == Verbosity.INFO;
    }

    public boolean isVerbose() {
        return this.verbosity == Verbosity.VERBOSE;
    }

    public boolean isDebug() {
        return this.verbosity == Verbosity.DEBUG;
    }

    public void flush() {
        this.out.flush();
        if (!this.isSharedOutputStreams()) {
            this.err.flush();
        }
    }

    public void close() throws IOException {
        IOUtil.close(this.in);
        IOUtil.close(this.out);
        if (!this.isSharedOutputStreams()) {
            IOUtil.close(this.err);
        }
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            this.out.println(msg);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebug()) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void verbose(String msg) {
        if (this.isVerbose()) {
            this.out.println(msg);
        }
    }

    public void verbose(String format, Object ... args) {
        if (this.isVerbose()) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void info(String msg) {
        if (!this.isQuiet()) {
            this.out.println(msg);
        }
    }

    public void info(String format, Object ... args) {
        if (!this.isQuiet()) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void warn(String msg) {
        if (!this.isQuiet()) {
            this.err.println(msg);
        }
    }

    public void warn(String format, Object ... args) {
        if (!this.isQuiet()) {
            this.err.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void error(String msg) {
        this.err.println(msg);
    }

    public void error(String format, Object ... args) {
        this.err.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Verbosity {
        QUIET,
        INFO,
        VERBOSE,
        DEBUG;

    }
}

