/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import java.io.PrintWriter;
import jline.ConsoleReader;
import jline.Terminal;
import org.apache.geronimo.gshell.ansi.ANSI;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.command.annotation.Requirement;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="gshell-builtins:clear", description="Clear the terminal screen")
public class ClearCommand
extends OsgiCommandSupport {
    @Requirement
    private Terminal terminal;

    public ClearCommand() {
    }

    public ClearCommand(Terminal terminal) {
        this.terminal = terminal;
    }

    protected OsgiCommandSupport createCommand() throws Exception {
        return new ClearCommand(this.terminal);
    }

    protected Object doExecute() throws Exception {
        ConsoleReader reader = new ConsoleReader(this.io.inputStream, new PrintWriter(this.io.outputStream, true), null, this.terminal);
        if (ANSI.isEnabled()) {
            reader.clearScreen();
            return SUCCESS;
        }
        this.io.out.println("ANSI is not enabled.  The clear command is not functional");
        return SUCCESS;
    }
}

