/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="gshell-builtins:echo", description="Echo or print arguments to STDOUT")
public class EchoCommand
extends OsgiCommandSupport {
    @Option(name="-n", description="Do not print the trailing newline character")
    private boolean trailingNewline = true;
    @Argument(description="Arguments")
    private List<String> args;

    protected Object doExecute() throws Exception {
        if (this.args != null) {
            int c = 0;
            for (String arg : this.args) {
                this.io.out.print(arg);
                if (++c + 1 >= this.args.size()) continue;
                this.io.out.print(" ");
            }
        }
        if (this.trailingNewline) {
            this.io.out.println();
        }
        return SUCCESS;
    }
}

