/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.common;

import java.io.PrintStream;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;

public class StreamPair {
    public final PrintStream out;
    public final PrintStream err;
    public final boolean combined;
    public static final StreamPair SYSTEM = StreamPair.system();

    public StreamPair(PrintStream out, PrintStream err) {
        assert (out != null);
        assert (err != null);
        this.out = out;
        this.err = err;
        this.combined = out == err;
    }

    public StreamPair(PrintStream out) {
        assert (out != null);
        this.out = out;
        this.err = out;
        this.combined = true;
    }

    public PrintStream get(Type type) {
        assert (type != null);
        return type.get(this);
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void flush() {
        this.out.flush();
        if (!this.combined) {
            this.err.flush();
        }
    }

    public void close() {
        this.out.close();
        if (!this.combined) {
            this.err.close();
        }
    }

    public static StreamPair system() {
        return new StreamPair(System.out, System.err);
    }

    public static void system(StreamPair streams) {
        assert (streams != null);
        System.setOut(streams.out);
        System.setErr(streams.err);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type OUT = new Type();
        public static final /* enum */ Type ERR = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static final Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private PrintStream get(StreamPair pair) {
            assert (pair != null);
            switch (this) {
                case OUT: {
                    return pair.out;
                }
                case ERR: {
                    return pair.err;
                }
            }
            throw new InternalError();
        }

        static {
            $VALUES = new Type[]{OUT, ERR};
        }
    }
}

