/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.loader;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.geronimo.gshell.GShell;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.model.application.Application;
import org.apache.geronimo.gshell.support.plexus.GShellPlexusContainer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GShellLoader {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassWorld classWorld;
    private final IO io;
    private Application application;
    private GShellPlexusContainer container;

    public GShellLoader(ClassWorld classWorld, IO io) throws Exception {
        assert (classWorld != null);
        assert (io != null);
        this.classWorld = classWorld;
        this.io = io;
    }

    public GShellLoader(IO io) throws Exception {
        this(new ClassWorld("gshell", Thread.currentThread().getContextClassLoader()), io);
    }

    public GShellLoader() throws Exception {
        this(new IO());
    }

    public ArtifactRepository createLocalRepository(File dir) throws ComponentLookupException, MalformedURLException {
        assert (dir != null);
        ArtifactRepositoryLayout layout = this.container.lookupComponent(ArtifactRepositoryLayout.class, "default");
        DefaultArtifactRepository repo = new DefaultArtifactRepository("local", dir.toURI().toURL().toExternalForm(), layout, new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
        repo.setBasedir(dir.getAbsolutePath());
        return repo;
    }

    public GShell load() throws Exception {
        return null;
    }

    public void test() throws Exception {
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setName("gshell");
        config.setClassWorld(this.classWorld);
        this.container = new GShellPlexusContainer((ContainerConfiguration)config);
        File repositoryDir = new File(new File(System.getProperty("user.home")), ".gshell/repository");
        ArtifactRepository repository = this.createLocalRepository(repositoryDir);
        System.out.println("Repository: " + repository);
    }

    public static void main(String[] args) throws Exception {
        GShellLoader loader = new GShellLoader();
        loader.test();
    }
}

