/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.gshell.descriptor.CommandDescriptor;
import org.apache.geronimo.gshell.descriptor.CommandSetDescriptor;
import org.apache.geronimo.gshell.plugin.ComponentSetDescriptorAdapter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=CommandDiscoveryListener.class)
public class CommandDiscoveryListener
implements ComponentDiscoveryListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, CommandDescriptor> descriptors = new HashMap<String, CommandDescriptor>();

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public void componentDiscovered(ComponentDiscoveryEvent event) {
        assert (event != null);
        this.log.trace("Event: {}", (Object)event);
        ComponentSetDescriptor components = event.getComponentSetDescriptor();
        if (components instanceof ComponentSetDescriptorAdapter) {
            CommandSetDescriptor commands = ((ComponentSetDescriptorAdapter)components).getCommands();
            for (CommandDescriptor descriptor : commands.getCommands()) {
                this.log.debug("Found: {}", (Object)descriptor);
                this.descriptors.put(descriptor.getId(), descriptor);
            }
        }
    }

    public CommandDescriptor getCommandDescriptor(String id) {
        assert (id != null);
        return this.descriptors.get(id);
    }
}

