/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.plugin;

import java.util.UUID;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.descriptor.CommandDescriptor;
import org.codehaus.plexus.PlexusContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlexusCommandWrapper
implements Command {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private CommandDescriptor descriptor;
    private PlexusContainer container;

    public PlexusCommandWrapper(PlexusContainer container, CommandDescriptor descriptor) {
        this.container = container;
        this.descriptor = descriptor;
    }

    public String getId() {
        return this.descriptor.getId();
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context, Object ... args) throws Exception {
        Object result;
        String realmId = "gshell:" + UUID.randomUUID();
        this.log.debug("Child container realm: {}", (Object)realmId);
        PlexusContainer childContainer = this.container.createChildContainer(realmId, this.container.getContainerRealm());
        Command command = (Command)childContainer.lookup(Command.class, this.descriptor.getId());
        try {
            result = command.execute(context, args);
        }
        finally {
            this.container.removeChildContainer(realmId);
        }
        return result;
    }
}

