/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.prefs;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import org.apache.geronimo.gshell.prefs.IllegalAnnotationError;
import org.apache.geronimo.gshell.prefs.Preference;
import org.apache.geronimo.gshell.prefs.ProcessingException;

public class PreferencesProcessor {
    private final Object bean;

    public PreferencesProcessor(Object bean) throws IllegalAnnotationError {
        assert (bean != null);
        this.bean = bean;
        this.discoverDescriptors();
    }

    public Object getBean() {
        return this.bean;
    }

    private void discoverDescriptors() {
        for (Class<?> type = this.bean.getClass(); type != null; type = type.getSuperclass()) {
            Preference pref;
            for (Method method : type.getDeclaredMethods()) {
                pref = method.getAnnotation(Preference.class);
                if (pref == null) continue;
            }
            for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
                pref = ((Field)accessibleObject).getAnnotation(Preference.class);
                if (pref == null) continue;
            }
        }
    }

    public void process(Preferences node) throws ProcessingException {
        assert (node != null);
    }
}

