/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server.auth;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.gshell.remote.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BogusLoginModule
implements LoginModule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Set<UserPrincipal> principals = new HashSet<UserPrincipal>();
    private String username;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    private void reset() {
        this.username = null;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        char[] passwd = ((PasswordCallback)callbacks[1]).getPassword();
        if ("bogus".equals(this.username)) {
            throw new FailedLoginException("Invalid username: " + this.username);
        }
        if ("bogus".equals(new String(passwd))) {
            throw new FailedLoginException("Invalid password");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        this.subject.getPrincipals().addAll(this.principals);
        this.reset();
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.reset();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.reset();
        return true;
    }
}

