/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.util.Map;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.common.Arguments;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.layout.NotFoundException;
import org.apache.geronimo.gshell.layout.model.AliasNode;
import org.apache.geronimo.gshell.layout.model.CommandNode;
import org.apache.geronimo.gshell.layout.model.GroupNode;
import org.apache.geronimo.gshell.layout.model.Layout;
import org.apache.geronimo.gshell.layout.model.Node;
import org.apache.geronimo.gshell.registry.DefaultCommandRegistry;
import org.apache.geronimo.gshell.registry.RegistryException;
import org.apache.geronimo.gshell.shell.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCommandRegistry
extends DefaultCommandRegistry
implements LayoutManager {
    public static final String SEPARATOR = ":";
    public static final String ALIAS_PREFIX = "alias:";
    private Environment env;
    private MutableLayout layout = new MutableLayout();

    public SpringCommandRegistry(Environment env) {
        this.env = env;
    }

    public void register(Command command, Map<String, ?> properties) throws RegistryException {
        String[] aliases;
        String name = command.getId();
        if (name.lastIndexOf(58) >= 0) {
            name = name.substring(name.lastIndexOf(58) + 1);
        }
        if (properties.containsKey("name")) {
            name = (String)properties.get("name");
        }
        int rank = 0;
        if (properties.containsKey("rank")) {
            rank = Integer.parseInt((String)properties.get("rank"));
        }
        GroupNode gn = this.layout;
        String shell = (String)properties.get("shell");
        String[] stringArray = aliases = properties.get("alias") != null ? properties.get("alias").toString().split(",") : new String[]{};
        if (name.equals(shell)) {
            Node n = gn.find(shell);
            MutableGroupNode g = new MutableGroupNode(shell);
            gn.add(g);
            this.register(command);
        } else {
            if (shell != null && shell.length() > 0) {
                Node n = gn.find(shell);
                if (n == null) {
                    MutableGroupNode g = new MutableGroupNode(shell);
                    gn.add(g);
                    this.register(new GroupCommand(shell, g));
                    gn = g;
                } else if (n instanceof GroupNode) {
                    gn = (GroupNode)n;
                } else {
                    throw new IllegalStateException("A command conflicts has been detected when registering " + command.getId());
                }
            }
            CommandNode cn = new CommandNode(name, command.getId());
            gn.add(cn);
            for (int i = 0; i < aliases.length; ++i) {
                if (name.equals(aliases[i])) continue;
                AliasNode an = new AliasNode(aliases[i], ALIAS_PREFIX + command.getId());
                gn.add(an);
            }
            this.register(command);
        }
    }

    public void unregister(Command command, Map<String, ?> properties) throws RegistryException {
        String shell;
        String name = command.getId();
        if (name.lastIndexOf(58) >= 0) {
            name = name.substring(name.lastIndexOf(58) + 1);
        }
        if (properties.containsKey("name")) {
            name = (String)properties.get("name");
        }
        if (name.equals(shell = (String)properties.get("shell")) || shell == null || shell.length() == 0) {
            Node n = this.layout.find(name);
            this.layout.removeNode(n);
        } else {
            MutableGroupNode gn = (MutableGroupNode)this.layout.find(shell);
            Node n = gn.find(name);
            gn.removeNode(n);
            if (gn.size() == 0) {
                this.layout.removeNode(gn);
                this.unregister(this.lookup(shell));
            }
        }
        this.unregister(command);
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public Node findNode(String s) throws NotFoundException {
        Node start = (Node)this.env.getVariables().get(CURRENT_NODE);
        if (start != null) {
            try {
                return this.findNode(start, s);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return this.findNode(this.layout, s);
    }

    @Override
    public Node findNode(Node node, String s) throws NotFoundException {
        if (node instanceof GroupNode) {
            if (s.startsWith(ALIAS_PREFIX)) {
                Node n = this.recursiveFind((GroupNode)node, s = s.substring(ALIAS_PREFIX.length()));
                if (n != null) {
                    return n;
                }
                throw new NotFoundException(s);
            }
            Node n = ((GroupNode)node).find(s);
            if (n == null) {
                throw new NotFoundException(s);
            }
            if (n instanceof GroupNode) {
                return new CommandNode(n.getName(), n.getName());
            }
            return n;
        }
        throw new NotFoundException(s);
    }

    private Node recursiveFind(GroupNode groupNode, String s) {
        for (Node n : groupNode.nodes()) {
            Node n2;
            if (n instanceof CommandNode && ((CommandNode)n).getId().equals(s)) {
                return n;
            }
            if (!(n instanceof GroupNode) || (n2 = this.recursiveFind((GroupNode)n, s)) == null) continue;
            return n2;
        }
        return null;
    }

    @Override
    public Node findNode(String path, String searchPath) throws NotFoundException {
        return this.findNode(path);
    }

    public static class MutableGroupNode
    extends GroupNode {
        public MutableGroupNode(String name) {
            super(name);
        }

        public void removeNode(Node n) {
            this.nodes.remove(n);
        }
    }

    public static class MutableLayout
    extends Layout {
        public void removeNode(Node n) {
            this.nodes.remove(n);
        }
    }

    public class GroupCommand
    implements Command {
        private String id;
        private GroupNode gn;

        public GroupCommand(String id, GroupNode gn) {
            this.id = id;
            this.gn = gn;
        }

        @Deprecated
        public String getId() {
            return this.id;
        }

        @Deprecated
        public String getDescription() {
            return "Group command";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(CommandContext commandContext, Object ... objects) throws Exception {
            SpringCommandRegistry.this.env.getVariables().set(LayoutManager.CURRENT_NODE, this.gn);
            if (objects.length > 0) {
                try {
                    Command cmd;
                    String cmdId = String.valueOf(objects[0]);
                    Node n = this.gn.find(cmdId);
                    if (n == null) {
                        n = SpringCommandRegistry.this.layout.find(cmdId);
                    }
                    if (n == null) {
                        throw new NotFoundException(cmdId);
                    }
                    CommandContext ctx = commandContext;
                    if (n instanceof CommandNode) {
                        cmd = SpringCommandRegistry.this.lookup(((CommandNode)n).getId());
                    } else if (n instanceof GroupNode) {
                        cmd = new GroupCommand(cmdId, (GroupNode)n);
                    } else if (n instanceof AliasNode) {
                        cmd = SpringCommandRegistry.this.lookup(((AliasNode)n).getCommand().substring(SpringCommandRegistry.ALIAS_PREFIX.length()));
                    } else {
                        throw new IllegalStateException("Unrecognized node type: " + n.getClass().getName());
                    }
                    Object object = cmd.execute(ctx, Arguments.shift(objects));
                    return object;
                }
                finally {
                    SpringCommandRegistry.this.env.getVariables().unset(LayoutManager.CURRENT_NODE);
                }
            }
            return SUCCESS;
        }
    }
}

