/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.geronimo.gshell.common.NestedIOException;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.whisper.stream.StreamMessage;
import org.apache.geronimo.gshell.whisper.util.SessionAttributeBinder;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInputStream
extends InputStream {
    public static final SessionAttributeBinder<SessionInputStream> BINDER = new SessionAttributeBinder(SessionInputStream.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object mutex = new Object();
    private final ByteBuffer buff = ByteBuffer.allocate((int)16);
    private volatile boolean closed;
    private volatile boolean released;
    private IOException exception;

    public SessionInputStream() {
        this.buff.setAutoExpand(true);
        this.buff.limit(0);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        if (this.released) {
            return 0;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.buff.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.closed = true;
            this.releaseBuffer();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            return this.buff.get() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            int readBytes = len > this.buff.remaining() ? this.buff.remaining() : len;
            this.buff.get(b, off, readBytes);
            return readBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForData() throws IOException {
        if (this.released) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (!this.released && this.buff.remaining() == 0 && this.exception == null) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new NestedIOException("Interrupted while waiting for more data");
                }
            }
        }
        if (this.exception != null) {
            this.releaseBuffer();
            throw this.exception;
        }
        if (this.closed && this.buff.remaining() == 0) {
            this.releaseBuffer();
            return false;
        }
        return true;
    }

    private void releaseBuffer() {
        if (this.released) {
            return;
        }
        this.released = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StreamMessage msg) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            ByteBuffer src = msg.getBuffer();
            this.log.debug("Writing {} bytes", (Object)src.remaining());
            if (this.buff.hasRemaining()) {
                this.buff.compact();
                this.buff.put(src);
                this.buff.flip();
            } else {
                this.buff.clear();
                this.buff.put(src);
                this.buff.flip();
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwException(IOException e) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.exception == null) {
                this.exception = e;
                this.mutex.notifyAll();
            }
        }
    }
}

