/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.stream;

import org.apache.geronimo.gshell.whisper.stream.SessionInputStream;
import org.apache.geronimo.gshell.whisper.stream.SessionOutputStream;
import org.apache.geronimo.gshell.whisper.stream.StreamMessage;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStreamFilter
extends IoFilterAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        SessionInputStream.BINDER.bind(session, new SessionInputStream());
        SessionOutputStream.BINDER.bind(session, new SessionOutputStream(session));
        nextFilter.sessionCreated(session);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        IOUtil.close(SessionInputStream.BINDER.unbind(session));
        IOUtil.close(SessionOutputStream.BINDER.unbind(session));
        nextFilter.sessionClosed(session);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof StreamMessage) {
            StreamMessage msg = (StreamMessage)message;
            SessionInputStream in = SessionInputStream.BINDER.lookup(session);
            in.write(msg);
        } else {
            nextFilter.messageReceived(session, message);
        }
    }
}

