/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.gshell.whisper.transport.InvalidLocationException;
import org.apache.geronimo.gshell.whisper.transport.LookupException;
import org.apache.geronimo.gshell.whisper.transport.TransportException;
import org.apache.geronimo.gshell.whisper.transport.TransportFactory;
import org.apache.geronimo.gshell.whisper.transport.TransportFactoryLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTransportFactoryLocator<T extends TransportFactory>
implements TransportFactoryLocator<T> {
    private List<T> factories;
    private Map<String, T> factoryMap;

    public List<T> getFactories() {
        return this.factories;
    }

    public void setFactories(List<T> factories) {
        this.factories = factories;
        this.factoryMap = new HashMap<String, T>();
        for (TransportFactory factory : factories) {
            this.factoryMap.put(factory.getScheme(), factory);
        }
    }

    @Override
    public T locate(URI location) throws TransportException {
        assert (location != null);
        String scheme = location.getScheme();
        if (scheme == null) {
            throw new InvalidLocationException(location);
        }
        TransportFactory factory = (TransportFactory)this.factoryMap.get(scheme);
        if (factory == null) {
            throw new LookupException(scheme);
        }
        return (T)factory;
    }
}

