/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geronimo.gshell.common.NamedThreadFactory;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolModel
implements ThreadModel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ThreadPoolExecutor threadPool;
    private final ExecutorFilter filter;

    public ThreadPoolModel(String name) {
        assert (name != null);
        ThreadGroup group = new ThreadGroup(name);
        NamedThreadFactory tf = new NamedThreadFactory(name, group);
        this.threadPool = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tf, new ThreadPoolExecutor.AbortPolicy());
        this.filter = new ExecutorFilter((Executor)this.threadPool);
    }

    public ThreadPoolModel(Class type, Object suffix) {
        this(type.getSimpleName() + "-" + suffix);
    }

    public ThreadPoolModel(Class type, AtomicLong counter) {
        this(type.getSimpleName() + "-" + counter.getAndIncrement());
    }

    public ThreadPoolModel(Class type, AtomicInteger counter) {
        this(type.getSimpleName() + "-" + counter.getAndIncrement());
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }

    public void buildFilterChain(IoFilterChain chain) throws Exception {
        assert (chain != null);
        chain.addFirst(this.getClass().getSimpleName(), (IoFilter)this.filter);
    }
}

