/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.stax.DOMStreamReader;
import org.apache.servicemix.soap.util.stax.StaxUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SoapOutInterceptor
extends AbstractInterceptor {
    private final SoapVersion soapVersion;

    public SoapOutInterceptor() {
        this(null);
    }

    public SoapOutInterceptor(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public void handleMessage(Message message) {
        XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
        if (writer == null) {
            throw new NullPointerException("XMLStreamWriter content not found");
        }
        SoapVersion soapVersion = message.get(SoapVersion.class);
        if (soapVersion == null && (soapVersion = this.soapVersion) == null) {
            throw new IllegalStateException("No soap version specified");
        }
        try {
            StaxUtil.writeStartElement(writer, soapVersion.getEnvelope());
            if (message.getSoapHeaders().size() > 0) {
                StaxUtil.writeStartElement(writer, soapVersion.getHeader());
                for (DocumentFragment df : message.getSoapHeaders().values()) {
                    Element e = DomUtil.getFirstChildElement(df);
                    StaxUtil.copy(new DOMStreamReader(e), writer);
                }
                writer.writeEndElement();
            }
            StaxUtil.writeStartElement(writer, soapVersion.getBody());
            InterceptorChain chain = message.get(InterceptorChain.class);
            chain.doIntercept(message);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }
}

