/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageVariableResolver
implements XPathVariableResolver {
    private static final transient Log LOG = LogFactory.getLog(MessageVariableResolver.class);
    private Exchange exchange;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public Object resolveVariable(QName name) {
        Message out;
        String uri = name.getNamespaceURI();
        String localPart = name.getLocalPart();
        Object answer = null;
        Message in = this.exchange.getIn();
        if (uri == null || uri.length() == 0) {
            answer = this.variables.get(localPart);
            if (answer == null) {
                Message message = in;
                if (message != null) {
                    answer = message.getHeader(localPart);
                }
                if (answer == null) {
                    answer = this.exchange.getProperty(localPart);
                }
            }
        } else if (uri.equals("http://camel.apache.org/xml/variables/system-properties")) {
            try {
                answer = System.getProperty(localPart);
            }
            catch (Exception e) {
                LOG.debug((Object)("Security exception evaluating system property: " + localPart + ". Reason: " + e), (Throwable)e);
            }
        } else if (uri.equals("http://camel.apache.org/xml/variables/environment-variables")) {
            answer = System.getenv().get(localPart);
        } else if (uri.equals("http://camel.apache.org/xml/variables/exchange-property")) {
            answer = this.exchange.getProperty(localPart);
        } else if (uri.equals("http://camel.apache.org/xml/in/")) {
            answer = in.getHeader(localPart);
            if (answer == null && localPart.equals("body")) {
                answer = in.getBody();
            }
        } else if (uri.equals("http://camel.apache.org/xml/out/") && (out = this.exchange.getOut(false)) != null && (answer = out.getHeader(localPart)) == null && localPart.equals("body")) {
            answer = out.getBody();
        }
        if (answer == null) {
            return Void.class;
        }
        return answer;
    }

    public void addVariable(String localPart, Object value) {
        this.variables.put(localPart, value);
    }
}

