/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SedaConsumer
extends ServiceSupport
implements Consumer,
Runnable {
    private static final transient Log LOG = LogFactory.getLog(SedaConsumer.class);
    private SedaEndpoint endpoint;
    private AsyncProcessor processor;
    private ExecutorService executor;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorTypeConverter.convert(processor);
    }

    public String toString() {
        return "SedaConsumer: " + this.endpoint.getEndpointUri();
    }

    public void run() {
        BlockingQueue<Exchange> queue = this.endpoint.getQueue();
        while (queue != null && this.isRunAllowed()) {
            Exchange exchange;
            try {
                exchange = queue.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Interupted: " + e), (Throwable)e);
                continue;
            }
            if (exchange == null) continue;
            if (this.isRunAllowed()) {
                try {
                    this.processor.process(exchange, new AsyncCallback(){

                        public void done(boolean sync) {
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Object)("Seda queue caught: " + e), (Throwable)e);
                }
                continue;
            }
            LOG.warn((Object)("This consumer is stopped during polling an exchange, so putting it back on the seda queue: " + exchange));
            try {
                queue.put(exchange);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Interupted: " + e), (Throwable)e);
            }
        }
    }

    protected void doStart() throws Exception {
        int concurrentConsumers = this.endpoint.getConcurrentConsumers();
        this.executor = Executors.newFixedThreadPool(concurrentConsumers, new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, SedaConsumer.this.getThreadName(SedaConsumer.this.endpoint.getEndpointUri()));
                thread.setDaemon(true);
                return thread;
            }
        });
        for (int i = 0; i < concurrentConsumers; ++i) {
            this.executor.execute(this);
        }
    }

    protected void doStop() throws Exception {
        this.executor.shutdownNow();
        this.executor = null;
    }
}

