/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="convertBodyTo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConvertBodyType
extends ProcessorType<ProcessorType> {
    @XmlAttribute
    private String type;
    @XmlTransient
    private Class typeClass;

    public ConvertBodyType() {
    }

    public ConvertBodyType(String type) {
        this.setType(type);
    }

    public ConvertBodyType(Class typeClass) {
        this.setTypeClass(typeClass);
        this.setType(typeClass.getName());
    }

    public String toString() {
        return "convertBodyTo[" + this.getType() + "]";
    }

    @Override
    public String getShortName() {
        return "convertBodyTo";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return new ConvertBodyProcessor(this.getTypeClass());
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    protected Class createTypeClass() {
        return ObjectHelper.loadClass(this.getType(), this.getClass().getClassLoader());
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setTypeClass(Class typeClass) {
        this.typeClass = typeClass;
    }

    public Class getTypeClass() {
        if (this.typeClass == null) {
            Class clazz = this.createTypeClass();
            if (clazz == null) {
                throw new RuntimeCamelException("Can't load the class with the class name: " + this.getType());
            }
            this.setTypeClass(clazz);
        }
        return this.typeClass;
    }
}

